/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.text;

import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TextWebCmsComponentModel
extends WebCmsComponentModel {
    private String content;
    private String profile;
    private boolean multiLine = true;
    private MarkupType markupType = MarkupType.MARKUP;
    private boolean parseContentMarkers;

    public TextWebCmsComponentModel(WebCmsComponent component) {
        super(component);
    }

    protected TextWebCmsComponentModel(WebCmsComponentModel template) {
        super(template);
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.content);
    }

    public void setContent(String content) {
        this.content = content;
        this.setParseContentMarkers(!this.isEmpty());
    }

    @Override
    public TextWebCmsComponentModel asComponentTemplate() {
        TextWebCmsComponentModel template = new TextWebCmsComponentModel(this);
        template.content = this.content;
        template.markupType = this.markupType;
        template.multiLine = this.multiLine;
        template.profile = this.profile;
        template.parseContentMarkers = this.parseContentMarkers;
        return template;
    }

    public String getContent() {
        return this.content;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public MarkupType getMarkupType() {
        return this.markupType;
    }

    public boolean isParseContentMarkers() {
        return this.parseContentMarkers;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public void setMarkupType(MarkupType markupType) {
        this.markupType = markupType;
    }

    public void setParseContentMarkers(boolean parseContentMarkers) {
        this.parseContentMarkers = parseContentMarkers;
    }

    public TextWebCmsComponentModel() {
    }

    public static enum MarkupType {
        PLAIN_TEXT("plain-text"),
        RICH_TEXT("rich-text"),
        MARKUP("markup");

        private final String attributeValue;

        private MarkupType(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public String asAttributeValue() {
            return this.attributeValue;
        }

        public static MarkupType forComponent(WebCmsComponent component) {
            return MarkupType.fromAttributeValue(component.getComponentType().getAttribute("type"));
        }

        public static MarkupType fromAttributeValue(String attributeValue) {
            return Stream.of(MarkupType.values()).filter(v -> StringUtils.equals((CharSequence)v.attributeValue, (CharSequence)attributeValue)).findFirst().orElse(null);
        }
    }

    public static interface Attributes {
        public static final String TYPE = "type";
        public static final String MULTI_LINE = "multiLine";
        public static final String PROFILE = "profile";
        public static final String ROWS = "rows";
    }
}

