/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.views.support.ValueFetcher;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

public class ComponentTypeFormProcessor
extends EntityViewProcessorAdapter
implements ValueFetcher<WebCmsObject> {
    public static final String COMPONENT_TYPES_CONTROL_NAME = "extensions[componentTypes].allowed";
    private final EntityViewRequest entityViewRequest;
    private final WebCmsTypeSpecifierLinkRepository typeLinkRepository;

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        command.addExtension("componentTypes", (Object)new componentTypesHolder());
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            WebCmsObject owner = (WebCmsObject)command.getEntity(WebCmsObject.class);
            componentTypesHolder typesHolder = (componentTypesHolder)command.getExtension("componentTypes", componentTypesHolder.class);
            Map currentLinks = this.typeLinkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(owner.getObjectId(), "component").stream().collect(Collectors.toMap(WebCmsTypeSpecifierLink::getTypeSpecifier, Function.identity()));
            ArrayList linksToCreate = new ArrayList();
            typesHolder.getAllowed().forEach(componentType -> {
                if (currentLinks.remove(componentType) == null) {
                    WebCmsTypeSpecifierLink link = new WebCmsTypeSpecifierLink();
                    link.setOwner(owner);
                    link.setTypeSpecifier((WebCmsTypeSpecifier)componentType);
                    link.setLinkType("component");
                    linksToCreate.add(link);
                }
            });
            currentLinks.values().forEach(arg_0 -> ((WebCmsTypeSpecifierLinkRepository)this.typeLinkRepository).delete(arg_0));
            linksToCreate.forEach(arg_0 -> ((WebCmsTypeSpecifierLinkRepository)this.typeLinkRepository).save(arg_0));
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        ContainerViewElementUtils.move((ContainerViewElement)container, (String)"formGroup-componentTypes", (String)"entityForm-column-1");
    }

    public Object getValue(WebCmsObject entity) {
        if (this.entityViewRequest.getHttpMethod() == HttpMethod.POST && this.entityViewRequest.getCommand().hasExtension("componentTypes")) {
            return ((componentTypesHolder)this.entityViewRequest.getCommand().getExtension((String)"componentTypes", componentTypesHolder.class)).allowed;
        }
        return entity.isNew() ? Collections.emptySet() : this.typeLinkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(entity.getObjectId(), "component").stream().map(WebCmsTypeSpecifierLink::getTypeSpecifier).collect(Collectors.toSet());
    }

    public ComponentTypeFormProcessor(EntityViewRequest entityViewRequest, WebCmsTypeSpecifierLinkRepository typeLinkRepository) {
        this.entityViewRequest = entityViewRequest;
        this.typeLinkRepository = typeLinkRepository;
    }

    class componentTypesHolder {
        Set<WebCmsComponentType> allowed = new HashSet<WebCmsComponentType>();

        public Set<WebCmsComponentType> getAllowed() {
            return this.allowed;
        }

        public void setAllowed(Set<WebCmsComponentType> allowed) {
            this.allowed = allowed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof componentTypesHolder)) {
                return false;
            }
            componentTypesHolder other = (componentTypesHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<WebCmsComponentType> this$allowed = this.getAllowed();
            Set<WebCmsComponentType> other$allowed = other.getAllowed();
            return !(this$allowed == null ? other$allowed != null : !((Object)this$allowed).equals(other$allowed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof componentTypesHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<WebCmsComponentType> $allowed = this.getAllowed();
            result = result * 59 + ($allowed == null ? 43 : ((Object)$allowed).hashCode());
            return result;
        }

        public String toString() {
            return "ComponentTypeFormProcessor.componentTypesHolder(allowed=" + this.getAllowed() + ")";
        }
    }
}

