/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.bootstrapui.elements.builder.OptionFormElementBuilder;
import com.foreach.across.modules.entity.views.bootstrapui.options.OptionIterableBuilder;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsAllowedComponentTypeFetcher;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnAdminUI
public class ComponentTypeOptionIterableBuilder
implements OptionIterableBuilder {
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private Collection<WebCmsAllowedComponentTypeFetcher> componentTypeFetchers = Collections.emptyList();

    public Iterable<OptionFormElementBuilder> buildOptions(ViewElementBuilderContext builderContext) {
        EntityViewCommand command = (EntityViewCommand)builderContext.getAttribute(EntityViewCommand.class);
        Object entity = command.getEntity();
        String ownerObjectId = null;
        if (entity != null) {
            ownerObjectId = ((WebCmsComponent)entity).getOwnerObjectId();
        }
        WebCmsObject owner = this.componentRepository.findOneByObjectId(ownerObjectId).orElse(null);
        Collection<WebCmsComponentType> allowedTypes = this.getAllowedTypes(owner, this.multiDomainService.getCurrentDomain());
        return allowedTypes.stream().map(type -> new OptionFormElementBuilder().rawValue(type).value((Object)type.getId()).controlName("entity.componentType").text(type.getName())).collect(Collectors.toList());
    }

    private Collection<WebCmsComponentType> getAllowedTypes(WebCmsObject owner, WebCmsDomain currentDomain) {
        return this.componentTypeFetchers.stream().filter(fetcher -> fetcher.supports(owner, currentDomain)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a handler for " + owner)).fetchComponentTypes(owner, currentDomain);
    }

    @Autowired
    void setComponentTypeFetchers(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsAllowedComponentTypeFetcher> componentTypeFetchers) {
        this.componentTypeFetchers = componentTypeFetchers;
    }

    public ComponentTypeOptionIterableBuilder(WebCmsComponentRepository componentRepository, WebCmsMultiDomainService multiDomainService) {
        this.componentRepository = componentRepository;
        this.multiDomainService = multiDomainService;
    }
}

