/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.elements.FormViewElement;
import com.foreach.across.modules.bootstrapui.styles.AcrossBootstrapStyles;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

@ConditionalOnAdminUI
@Component
public class ContainerMemberViewProcessor
extends EntityViewProcessorAdapter {
    private final WebCmsComponentModelService componentModelService;

    protected void validateCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, Errors errors, HttpMethod httpMethod) {
        WebCmsComponentModel ownerModel;
        WebCmsComponent component;
        if (HttpMethod.POST.equals((Object)entityViewRequest.getHttpMethod()) && (component = (WebCmsComponent)command.getEntity(WebCmsComponent.class)) != null && component.hasOwner() && (ownerModel = this.componentModelService.getComponentModel(component.getOwnerObjectId())) != null && ownerModel instanceof ContainerWebCmsComponentModel) {
            component.setSortIndex(((ContainerWebCmsComponentModel)ownerModel).size() + 1);
        }
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        String redirectTargetUrl;
        if (entityView.isRedirect() && (redirectTargetUrl = entityViewRequest.getWebRequest().getParameter("from")) != null) {
            entityView.setRedirectUrl(redirectTargetUrl);
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        WebCmsComponent component = (WebCmsComponent)entityViewRequest.getCommand().getEntity(WebCmsComponent.class);
        if (component == null) {
            component = (WebCmsComponent)entityViewRequest.getEntityViewContext().getEntity(WebCmsComponent.class);
        }
        if (component != null && component.hasOwner()) {
            entityViewRequest.getPageContentStructure().withNav(ContainerViewElement::clearChildren);
        }
        ContainerViewElementUtils.find((ContainerViewElement)container, (String)"entityForm", FormViewElement.class).ifPresent(fve -> fve.set(new ViewElement.WitherSetter[]{AcrossBootstrapStyles.css.padding.top.s3}));
        container.find("formGroup-title", FormGroupElement.class).ifPresent(group -> group.setRequired(false));
        container.find("formGroup-name", FormGroupElement.class).ifPresent(group -> group.setRequired(false));
    }

    public ContainerMemberViewProcessor(WebCmsComponentModelService componentModelService) {
        this.componentModelService = componentModelService;
    }
}

