/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.modules.entity.bind.EntityPropertyControlName;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.support.EntityMessageCodeResolver;
import com.foreach.across.modules.entity.support.EntityViewMessageSource;
import com.foreach.across.modules.entity.views.EntityViewElementBuilderHelper;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.helpers.EntityViewElementBatch;
import com.foreach.across.modules.web.support.LocalizedTextResolver;
import com.foreach.across.modules.web.support.MessageCodeSupportingLocalizedTextResolver;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelFormElementBuilder;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelMetadataAdminRenderer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@ConditionalOnAdminUI
@Component
@Order(value=0x7FFFFFFF)
class EntityBasedMetadataAdminRenderer
implements WebCmsComponentModelMetadataAdminRenderer<WebCmsComponentModel, Object> {
    private final EntityViewElementBuilderHelper builderHelper;
    private final EntityRegistry entityRegistry;

    @Override
    public boolean supports(WebCmsComponentModel componentModel, Object metadata) {
        return metadata != null && this.entityRegistry.contains(ClassUtils.getUserClass((Object)metadata));
    }

    @Override
    public ViewElementBuilder createMetadataViewElementBuilder(WebCmsComponentModel componentModel, Object metadata, String controlNamePrefix) {
        return builderContext -> {
            EntityViewElementBatch formBuilder = this.builderHelper.createBatchForEntity(metadata);
            formBuilder.setViewElementMode(ViewElementMode.FORM_WRITE);
            formBuilder.setAttribute(EntityPropertyControlName.class, (Object)EntityPropertyControlName.root((String)(controlNamePrefix + ".metadata")));
            String messageCodePrefix = StringUtils.defaultString((String)((String)builderContext.getAttribute(WebCmsComponentModelFormElementBuilder.COMPONENT_MESSAGE_CODE_PREFIX, String.class)));
            EntityMessageCodeResolver componentsResolver = (EntityMessageCodeResolver)builderContext.getAttribute(EntityMessageCodeResolver.class);
            EntityMessageCodeResolver metadataCodeResolver = (EntityMessageCodeResolver)formBuilder.getAttribute(EntityMessageCodeResolver.class);
            EntityMessageCodeResolver nestedResolver = new EntityMessageCodeResolver(metadataCodeResolver);
            nestedResolver.setPrefixes(componentsResolver.buildMessageCodes(messageCodePrefix + ".metadata", false));
            nestedResolver.setFallbackCollections(metadataCodeResolver.buildMessageCodes("", true));
            formBuilder.setAttribute(EntityMessageCodeResolver.class, (Object)nestedResolver);
            EntityViewMessageSource viewMessageSource = new EntityViewMessageSource(nestedResolver);
            formBuilder.setAttribute(MessageSource.class, (Object)viewMessageSource);
            formBuilder.setAttribute(LocalizedTextResolver.class, (Object)new MessageCodeSupportingLocalizedTextResolver((MessageSource)viewMessageSource));
            ContainerViewElement container = new ContainerViewElement();
            formBuilder.build().forEach((name, element) -> container.addChild(element));
            return container;
        };
    }

    public EntityBasedMetadataAdminRenderer(EntityViewElementBuilderHelper builderHelper, EntityRegistry entityRegistry) {
        this.builderHelper = builderHelper;
        this.entityRegistry = entityRegistry;
    }
}

