/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.modules.bootstrapui.elements.builder.InputGroupFormElementBuilder;
import com.foreach.across.modules.bootstrapui.elements.builder.TableViewElementBuilder;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.query.EntityQuery;
import com.foreach.across.modules.entity.query.EntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQueryParser;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.EntityViewElementBuilderHelper;
import com.foreach.across.modules.entity.views.bootstrapui.util.SortableTableBuilder;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.support.ViewElementBuilderMap;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.views.util.EntityViewElementUtils;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilderSupport;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.WebCmsModuleIcons;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentUtils;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierRepository;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@ConditionalOnAdminUI
@Component
public final class SearchComponentViewProcessor
extends EntityViewProcessorAdapter {
    public static final String COMPONENT_SEARCH_QUERY = SearchComponentViewProcessor.class.getName() + ".SEARCH_QUERY";
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsTypeSpecifierRepository typeSpecifierRepository;
    private final WebCmsAssetRepository assetRepository;
    private final EntityRegistry entityRegistry;
    private final EntityViewElementBuilderHelper builderHelper;

    protected void doGet(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
        NativeWebRequest request = entityViewRequest.getWebRequest();
        String parent = request.getParameter("parent");
        if (parent != null) {
            entityView.addAttribute("items", this.componentRepository.findAllByOwnerObjectIdAndDomainOrderBySortIndexAsc(parent, WebCmsDomain.NONE));
        } else {
            entityView.addAttribute("items", Collections.emptyList());
        }
    }

    protected void createViewElementBuilders(EntityViewRequest entityViewRequest, EntityView entityView, ViewElementBuilderMap builderMap) {
        NativeWebRequest request = entityViewRequest.getWebRequest();
        String parent = request.getParameter("parent");
        String filterType = request.getParameter("filter");
        if (parent == null) {
            builderMap.remove((Object)"sortableTableBuilder");
            NodeViewElementBuilder pills = HtmlViewElements.html.builders.ul(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.css((String[])new String[]{"nav", "nav-pills"})});
            this.entityRegistry.getEntities().stream().filter(entityConfiguration -> entityConfiguration.hasAttribute(COMPONENT_SEARCH_QUERY)).forEach(entityConfiguration -> {
                String url = ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("filter", new Object[]{entityConfiguration.getName()}).toUriString();
                pills.add(new ViewElementBuilder[]{((NodeViewElementBuilder)HtmlViewElements.html.builders.li().css(new String[]{entityConfiguration.getName().equals(filterType) ? "active" : null})).add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.link().url(url).text(entityConfiguration.getEntityMessageCodeResolver().getNameSingular())})});
            });
            builderMap.put((Object)"filter", (Object)((ContainerViewElementBuilder)HtmlViewElements.html.builders.container().name("filter")).add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.hidden().controlName("filter").value((Object)filterType)}).add(new ViewElementBuilder[]{pills}).add(new ViewElementBuilder[]{((InputGroupFormElementBuilder)BootstrapViewElements.bootstrap.builders.inputGroup().control((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.textbox().controlName("qs").text(request.getParameter("qs")))).append((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.button().submit().iconOnly((ViewElement)WebCmsModuleIcons.webCmsIcons.component.search()))}));
        } else {
            SortableTableBuilder sortableTableBuilder = (SortableTableBuilder)builderMap.get("sortableTableBuilder", SortableTableBuilder.class);
            sortableTableBuilder.tableOnly();
            this.registerOpenButtonOnRow(sortableTableBuilder);
        }
    }

    protected void render(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElementBuilderSupport<?, ?> containerBuilder, ViewElementBuilderMap builderMap, ViewElementBuilderContext builderContext) {
        NativeWebRequest request = entityViewRequest.getWebRequest();
        String parent = request.getParameter("parent");
        NodeViewElementBuilder breadcrumb = HtmlViewElements.html.builders.ol(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.css((String[])new String[]{"breadcrumb", "wcm-component-search-trail"})});
        this.addComponentToBreadcrumb(parent, breadcrumb, false);
        breadcrumb.addFirst(new ViewElementBuilder[]{HtmlViewElements.html.builders.li().add(new ViewElementBuilder[]{parent != null ? BootstrapViewElements.bootstrap.builders.link().url(ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("parent", new Object[0]).toUriString()).text("Search components") : HtmlViewElements.html.builders.text("Search components")})});
        containerBuilder.addFirst(new ViewElementBuilder[]{breadcrumb});
        if (builderMap.containsKey((Object)"filter")) {
            containerBuilder.add(new ViewElementBuilder[]{(ViewElementBuilder)builderMap.get((Object)"filter")});
        }
        String filterType = request.getParameter("filter");
        String qs = StringUtils.defaultString((String)request.getParameter("qs"));
        if (filterType != null && parent == null) {
            EntityConfiguration configuration = this.entityRegistry.getEntityConfiguration(filterType);
            EntityQueryParser entityQueryParser = (EntityQueryParser)configuration.getAttribute(EntityQueryParser.class);
            EntityQueryExecutor entityQueryExecutor = (EntityQueryExecutor)configuration.getAttribute(EntityQueryExecutor.class);
            String baseQuery = (String)configuration.getAttribute(COMPONENT_SEARCH_QUERY, String.class);
            EntityQuery query = entityQueryParser.parse(baseQuery.replace("{0}", qs));
            SortableTableBuilder tableBuilder = this.builderHelper.createSortableTableBuilder();
            tableBuilder.entityConfiguration(configuration);
            tableBuilder.properties(new String[]{"title"});
            tableBuilder.items(entityQueryExecutor.findAll(query));
            tableBuilder.tableOnly(true);
            tableBuilder.showResultNumber(false);
            tableBuilder.noSorting();
            this.registerOpenButtonOnRow(tableBuilder);
            containerBuilder.add(new ViewElementBuilder[]{tableBuilder});
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        ContainerViewElementUtils.move((ContainerViewElement)container, (String)"filter", (String)"entityListForm-header");
    }

    private void registerOpenButtonOnRow(SortableTableBuilder sortableTableBuilder) {
        TableViewElementBuilder table = BootstrapViewElements.bootstrap.builders.table();
        sortableTableBuilder.headerRowProcessor((viewElementBuilderContext, row) -> {
            row.addFirstChild((ViewElement)table.heading().build(viewElementBuilderContext));
            row.addChild((ViewElement)table.heading().build(viewElementBuilderContext));
        });
        sortableTableBuilder.valueRowProcessor((viewElementBuilderContext, row) -> {
            WebCmsObject object = (WebCmsObject)EntityViewElementUtils.currentEntity((ViewElementBuilderContext)viewElementBuilderContext, WebCmsObject.class);
            if (object instanceof WebCmsComponent) {
                row.addFirstChild((ViewElement)((TableViewElementBuilder.Cell)table.cell().add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.radio().unwrapped().name("selectedComponent").value((Object)object.getObjectId())})).build(viewElementBuilderContext));
                if (WebCmsComponentUtils.isContainerType(((WebCmsComponent)object).getComponentType())) {
                    String url = ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("parent", new Object[]{object.getObjectId()}).toUriString();
                    row.addChild((ViewElement)((TableViewElementBuilder.Cell)table.cell().add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.link().url(url).title("View container members").add(new ViewElement[]{WebCmsModuleIcons.webCmsIcons.component.viewMembers()})})).build(viewElementBuilderContext));
                } else {
                    row.addChild((ViewElement)table.cell().build(viewElementBuilderContext));
                }
            } else {
                row.addFirstChild((ViewElement)table.cell().build(viewElementBuilderContext));
                String url = ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("parent", new Object[]{object.getObjectId()}).toUriString();
                row.addChild((ViewElement)((TableViewElementBuilder.Cell)table.cell().add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.link().url(url).title("View components").add(new ViewElement[]{WebCmsModuleIcons.webCmsIcons.component.viewMembers()})})).build(viewElementBuilderContext));
            }
        });
    }

    private void addComponentToBreadcrumb(String parent, NodeViewElementBuilder breadcrumb, boolean asLink) {
        WebCmsObject nonObjectOwner;
        WebCmsComponent owner = this.componentRepository.findOneByObjectId(parent).orElse(null);
        if (owner != null) {
            String url = ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("parent", new Object[]{owner.getObjectId()}).toUriString();
            String title = (String)StringUtils.defaultIfBlank((CharSequence)owner.getTitle(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)owner.getName(), (CharSequence)owner.getComponentType().getName()));
            breadcrumb.addFirst(new ViewElementBuilder[]{HtmlViewElements.html.builders.li().add(new ViewElementBuilder[]{asLink ? BootstrapViewElements.bootstrap.builders.link().url(url).title(owner.getName()).text(title) : HtmlViewElements.html.builders.text(title)})});
            if (owner.hasOwner()) {
                this.addComponentToBreadcrumb(owner.getOwnerObjectId(), breadcrumb, true);
            }
        }
        if ((nonObjectOwner = this.retrieveOwner(parent)) != null) {
            this.addObjectToBreadcrumb(nonObjectOwner, breadcrumb, asLink);
        }
    }

    private void addObjectToBreadcrumb(WebCmsObject object, NodeViewElementBuilder breadcrumb, boolean asLink) {
        String url = ServletUriComponentsBuilder.fromCurrentRequest().replaceQueryParam("parent", new Object[]{object.getObjectId()}).toUriString();
        EntityConfiguration configuration = this.entityRegistry.getEntityConfiguration((Object)object);
        String name = configuration.getEntityMessageCodeResolver().getNameSingular();
        String title = name + ": " + configuration.getLabel((Object)object);
        breadcrumb.addFirst(new ViewElementBuilder[]{HtmlViewElements.html.builders.li().add(new ViewElementBuilder[]{asLink ? BootstrapViewElements.bootstrap.builders.link().url(url).title(title).text(title) : HtmlViewElements.html.builders.text(title)})});
    }

    private WebCmsObject retrieveOwner(String ownerId) {
        WebCmsObject owner = this.assetRepository.findOneByObjectId(ownerId).orElse(null);
        if (owner == null) {
            owner = this.typeSpecifierRepository.findOneByObjectId(ownerId).orElse(null);
        }
        return owner;
    }

    public SearchComponentViewProcessor(WebCmsComponentRepository componentRepository, WebCmsTypeSpecifierRepository typeSpecifierRepository, WebCmsAssetRepository assetRepository, EntityRegistry entityRegistry, EntityViewElementBuilderHelper builderHelper) {
        this.componentRepository = componentRepository;
        this.typeSpecifierRepository = typeSpecifierRepository;
        this.assetRepository = assetRepository;
        this.entityRegistry = entityRegistry;
        this.builderHelper = builderHelper;
    }
}

