/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.modules.bootstrapui.elements.ButtonViewElement;
import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.elements.builder.ColumnViewElementBuilder;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.context.EntityViewContext;
import com.foreach.across.modules.entity.views.processors.SaveEntityViewProcessor;
import com.foreach.across.modules.entity.views.processors.support.EntityViewPageHelper;
import com.foreach.across.modules.entity.views.processors.support.ViewElementBuilderMap;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewCommandValidator;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.web.links.EntityViewLinkBuilder;
import com.foreach.across.modules.entity.web.links.SingleEntityViewLinkBuilder;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilderSupport;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentValidator;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelAdminRenderService;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import javax.servlet.http.HttpServletRequest;
import javax.validation.groups.Default;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.util.UrlPathHelper;

@ConditionalOnAdminUI
@Component
public class SingleWebCmsComponentFormProcessor
extends SaveEntityViewProcessor {
    private static final String EXTENSION_NAME = "componentModel";
    private final EntityViewPageHelper entityViewPageHelper;
    private final WebCmsComponentModelService componentModelService;
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsComponentModelAdminRenderService componentModelAdminRenderService;
    private final EntityViewCommandValidator entityViewCommandValidator;
    private final WebCmsComponentValidator componentValidator;

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        dataBinder.setValidator((Validator)this.entityViewCommandValidator);
        super.initializeCommandObject(entityViewRequest, command, dataBinder);
        WebCmsComponentModel componentModel = this.componentModelService.buildModelForComponent((WebCmsComponent)command.getEntity(WebCmsComponent.class));
        command.addExtension(EXTENSION_NAME, (Object)componentModel);
    }

    protected void validateCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, Errors errors, HttpMethod httpMethod) {
        WebCmsComponentModel componentModel = (WebCmsComponentModel)command.getExtension(EXTENSION_NAME, WebCmsComponentModel.class);
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            Object[] objectArray;
            boolean sharedValidation;
            boolean bl = sharedValidation = !componentModel.hasOwner() || this.componentRepository.findOneByObjectId(componentModel.getOwnerObjectId()) == null;
            if (sharedValidation) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = Default.class;
                objectArray = objectArray2;
                objectArray2[1] = WebCmsComponent.SharedComponentValidation.class;
            } else {
                objectArray = new Object[]{};
            }
            Object[] validationHints = objectArray;
            entityViewRequest.getDataBinder().validate(validationHints);
            if (!errors.hasErrors()) {
                errors.pushNestedPath("extensions[componentModel].component");
                this.componentValidator.validate(componentModel.getComponent(), errors, validationHints);
                errors.popNestedPath();
            }
        }
    }

    protected void doControl(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult, HttpMethod httpMethod) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        entityView.addAttribute("currentComponentUrl", (Object)pathHelper.getPathWithinApplication((HttpServletRequest)entityViewRequest.getWebRequest().getNativeRequest(HttpServletRequest.class)));
        entityView.addAttribute("componentLinkBuilder", component -> entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance((Object)component).updateView());
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!this.hasComponentModelErrors((Errors)bindingResult)) {
            try {
                EntityViewContext entityViewContext = entityViewRequest.getEntityViewContext();
                WebCmsComponentModel componentModel = (WebCmsComponentModel)command.getExtension(EXTENSION_NAME, WebCmsComponentModel.class);
                boolean isNew = componentModel.isNew();
                WebCmsComponent savedEntity = this.componentModelService.save(componentModel);
                this.entityViewPageHelper.addGlobalFeedbackAfterRedirect(entityViewRequest, Style.SUCCESS, isNew ? "feedback.entityCreated" : "feedback.entityUpdated");
                String fromUrl = entityViewRequest.getWebRequest().getParameter("from");
                SingleEntityViewLinkBuilder redirectTarget = entityViewContext.getLinkBuilder().forInstance((Object)savedEntity).updateView();
                if (!isNew && fromUrl != null) {
                    redirectTarget = (SingleEntityViewLinkBuilder)redirectTarget.withFromUrl(fromUrl);
                }
                if (entityViewRequest.hasPartialFragment()) {
                    redirectTarget = (SingleEntityViewLinkBuilder)redirectTarget.withPartial(entityViewRequest.getPartialFragment());
                }
                entityView.setRedirectUrl(redirectTarget.toUriString());
            }
            catch (RuntimeException e) {
                this.entityViewPageHelper.throwOrAddExceptionFeedback(entityViewRequest, "feedback.entitySaveFailed", (Throwable)e);
            }
        }
    }

    private boolean hasComponentModelErrors(Errors errors) {
        return errors.hasGlobalErrors() || errors.getFieldErrors().stream().anyMatch(field -> !field.getField().startsWith("entity."));
    }

    protected void render(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElementBuilderSupport<?, ?> containerBuilder, ViewElementBuilderMap builderMap, ViewElementBuilderContext builderContext) {
        NodeViewElementBuilder ownerTrail;
        WebCmsComponentModel componentModel = (WebCmsComponentModel)entityViewRequest.getCommand().getExtension(EXTENSION_NAME, WebCmsComponentModel.class);
        ColumnViewElementBuilder columnViewElementBuilder = (ColumnViewElementBuilder)builderMap.get("entityForm-column-0", ColumnViewElementBuilder.class);
        if (componentModel.hasOwner() && this.addToOwnerTrail(ownerTrail = HtmlViewElements.html.builders.ul(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.css((String[])new String[]{"breadcrumb", "wcm-component-owner-trail"})}), componentModel.getObjectId(), entityViewRequest.getEntityViewContext().getLinkBuilder(), false)) {
            columnViewElementBuilder.add(new ViewElementBuilder[]{ownerTrail});
        }
        columnViewElementBuilder.add(new ViewElementBuilder[]{this.componentModelAdminRenderService.createFormElement(componentModel, "extensions[componentModel]")});
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        if (StringUtils.isEmpty((CharSequence)entityViewRequest.getWebRequest().getParameter("from"))) {
            WebCmsComponentModel component = (WebCmsComponentModel)entityViewRequest.getCommand().getExtension(EXTENSION_NAME, WebCmsComponentModel.class);
            String ownerObjectId = component != null ? component.getOwnerObjectId() : null;
            ContainerViewElementUtils.find((ContainerViewElement)container, (String)"btn-cancel", ButtonViewElement.class).ifPresent(btn -> {
                if (StringUtils.isNotEmpty((CharSequence)ownerObjectId) && WebCmsUtils.isObjectIdForCollection(ownerObjectId, "wcm:component")) {
                    EntityViewContext entityViewContext = entityViewRequest.getEntityViewContext();
                    WebCmsComponent owner = this.componentRepository.findOneByObjectId(ownerObjectId).orElse(null);
                    btn.setUrl(entityViewContext.getLinkBuilder().forInstance((Object)owner).updateView().toUriString());
                }
            });
        }
    }

    private boolean addToOwnerTrail(NodeViewElementBuilder breadcrumb, String objectId, EntityViewLinkBuilder linkBuilder, boolean createLink) {
        WebCmsComponent owner = this.componentRepository.findOneByObjectId(objectId).orElse(null);
        if (owner != null) {
            String title = (String)StringUtils.defaultIfBlank((CharSequence)owner.getTitle(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)owner.getName(), (CharSequence)owner.getComponentType().getName()));
            breadcrumb.addFirst(new ViewElementBuilder[]{((NodeViewElementBuilder)((NodeViewElementBuilder)HtmlViewElements.html.builders.li().attribute("title", (Object)owner.getName())).with(new ViewElement.WitherSetter[]{BootstrapStyles.css.breadcrumb.item})).add(new ViewElementBuilder[]{createLink ? BootstrapViewElements.bootstrap.builders.link().url(linkBuilder.forInstance((Object)owner).updateView().toUriString()).text(title) : HtmlViewElements.html.builders.text(title)})});
            if (owner.hasOwner()) {
                return this.addToOwnerTrail(breadcrumb, owner.getOwnerObjectId(), linkBuilder, true) || createLink;
            }
            return createLink;
        }
        return false;
    }

    protected void registerWebResources(EntityViewRequest entityViewRequest, EntityView entityView, WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"wcm-components-admin"});
    }

    public SingleWebCmsComponentFormProcessor(EntityViewPageHelper entityViewPageHelper, WebCmsComponentModelService componentModelService, WebCmsComponentRepository componentRepository, WebCmsComponentModelAdminRenderService componentModelAdminRenderService, EntityViewCommandValidator entityViewCommandValidator, WebCmsComponentValidator componentValidator) {
        this.entityViewPageHelper = entityViewPageHelper;
        this.componentModelService = componentModelService;
        this.componentRepository = componentRepository;
        this.componentModelAdminRenderService = componentModelAdminRenderService;
        this.entityViewCommandValidator = entityViewCommandValidator;
        this.componentValidator = componentValidator;
    }
}

