/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.elements.Grid;
import com.foreach.across.modules.bootstrapui.elements.builder.ColumnViewElementBuilder;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.bind.EntityPropertyControlName;
import com.foreach.across.modules.entity.registry.properties.EntityPropertySelector;
import com.foreach.across.modules.entity.support.EntityMessageCodeResolver;
import com.foreach.across.modules.entity.views.EntityViewElementBuilderHelper;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.helpers.EntityViewElementBatch;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelContentAdminRenderer;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelFormElementBuilder;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelMembersAdminRenderer;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelMetadataAdminRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ConditionalOnAdminUI
@Service
public final class WebCmsComponentModelAdminRenderService {
    private final EntityViewElementBuilderHelper builderHelper;
    private final WebCmsComponentRepository componentRepository;
    private Collection<WebCmsComponentModelContentAdminRenderer> contentRenderers = Collections.emptyList();
    private Collection<WebCmsComponentModelMetadataAdminRenderer> metadataRenderers = Collections.emptyList();
    private Collection<WebCmsComponentModelMembersAdminRenderer> membersRenderers = Collections.emptyList();

    public WebCmsComponentModelFormElementBuilder createFormElement(WebCmsComponentModel componentModel, String controlNamePrefix) {
        WebCmsComponentModelFormElementBuilder formElementBuilder = new WebCmsComponentModelFormElementBuilder(componentModel);
        formElementBuilder.settings(this.createSettingsViewElementBuilder(componentModel, controlNamePrefix));
        this.createContentViewElementBuilder(componentModel, controlNamePrefix).ifPresent(formElementBuilder::content);
        this.createMembersViewElementBuilder(componentModel, controlNamePrefix).ifPresent(formElementBuilder::members);
        this.createMetadataViewElementBuilder(componentModel, controlNamePrefix).ifPresent(formElementBuilder::metadata);
        if (componentModel instanceof ContainerWebCmsComponentModel && !((ContainerWebCmsComponentModel)componentModel).isFixed()) {
            formElementBuilder.showAddComponentButton(true);
            formElementBuilder.sortableContainer(true);
        }
        formElementBuilder.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.hidden().controlName(controlNamePrefix + ".component.sortIndex").value((Object)componentModel.getComponent().getSortIndex())});
        return formElementBuilder;
    }

    public ViewElementBuilder createSettingsViewElementBuilder(WebCmsComponentModel componentModel, String controlNamePrefix) {
        HashMap<String, ViewElementMode> builderHints = new HashMap<String, ViewElementMode>();
        builderHints.put("componentType", ViewElementMode.FORM_READ);
        builderHints.put("lastModified", ViewElementMode.FORM_READ);
        EntityViewElementBatch generalSettingsBuilder = this.builderHelper.createBatchForEntityType(WebCmsComponent.class);
        generalSettingsBuilder.setPropertySelector(EntityPropertySelector.of((String[])new String[]{"componentType", "title", "name", "lastModified"}));
        generalSettingsBuilder.setViewElementMode(ViewElementMode.FORM_WRITE);
        generalSettingsBuilder.setBuilderHints(builderHints);
        generalSettingsBuilder.setEntity((Object)componentModel.getComponent());
        generalSettingsBuilder.setAttribute(EntityPropertyControlName.class, (Object)EntityPropertyControlName.root((String)(controlNamePrefix + ".component")));
        EntityMessageCodeResolver messageCodeResolver = (EntityMessageCodeResolver)generalSettingsBuilder.getAttribute(EntityMessageCodeResolver.class);
        generalSettingsBuilder.setAttribute(EntityMessageCodeResolver.class, (Object)messageCodeResolver.prefixedResolver(new String[]{componentModel.hasOwner() ? "views[updateMember]" : "views[updateView]"}));
        Map formGroups = generalSettingsBuilder.build();
        WebCmsComponent ownerContainer = componentModel.hasOwner() ? (WebCmsComponent)this.componentRepository.findOneByObjectId(componentModel.getOwnerObjectId()).orElse(null) : null;
        return ((NodeViewElementBuilder)((NodeViewElementBuilder)BootstrapViewElements.bootstrap.builders.row().add(new ViewElementBuilder[]{((ColumnViewElementBuilder)((ColumnViewElementBuilder)BootstrapViewElements.bootstrap.builders.column(new Grid.DeviceGridLayout[]{Grid.Device.MEDIUM.width(6)}).add(new ViewElement[]{(ViewElement)formGroups.get("title")})).add(new ViewElement[]{(ViewElement)formGroups.get("name")})).add(new ViewElement[]{(ViewElement)formGroups.get("sortIndex")})})).add(new ViewElementBuilder[]{((ColumnViewElementBuilder)BootstrapViewElements.bootstrap.builders.column(new Grid.DeviceGridLayout[]{Grid.Device.MEDIUM.width(6)}).add(new ViewElement[]{(ViewElement)formGroups.get("componentType")})).add(new ViewElement[]{(ViewElement)formGroups.get("lastModified")})})).postProcessor((builderContext, container) -> {
            if (ownerContainer != null) {
                container.find("formGroup-title", FormGroupElement.class).ifPresent(group -> group.setRequired(false));
                container.find("formGroup-name", FormGroupElement.class).ifPresent(group -> group.setRequired(false));
            }
        });
    }

    public Optional<ViewElementBuilder> createContentViewElementBuilder(WebCmsComponentModel componentModel, String controlNamePrefix) {
        return this.contentRenderers.stream().filter(r -> r.supports(componentModel)).findFirst().map(r -> r.createContentViewElementBuilder(componentModel, controlNamePrefix));
    }

    public Optional<ViewElementBuilder> createMembersViewElementBuilder(WebCmsComponentModel componentModel, String controlNamePrefix) {
        return this.membersRenderers.stream().filter(r -> r.supports(componentModel)).findFirst().map(r -> r.createMembersViewElementBuilder(componentModel, controlNamePrefix));
    }

    public Optional<ViewElementBuilder> createMetadataViewElementBuilder(WebCmsComponentModel componentModel, String controlNamePrefix) {
        if (componentModel.hasMetadata()) {
            return this.metadataRenderers.stream().filter(r -> r.supports(componentModel, componentModel.getMetadata())).findFirst().map(r -> r.createMetadataViewElementBuilder(componentModel, componentModel.getMetadata(), controlNamePrefix));
        }
        return Optional.empty();
    }

    @Autowired
    void setContentRenderers(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsComponentModelContentAdminRenderer> contentRenderers) {
        this.contentRenderers = contentRenderers;
    }

    @Autowired
    void setMetadataRenderers(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsComponentModelMetadataAdminRenderer> metadataRenderers) {
        this.metadataRenderers = metadataRenderers;
    }

    @Autowired
    void setMembersRenderers(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsComponentModelMembersAdminRenderer> membersRenderers) {
        this.membersRenderers = membersRenderers;
    }

    public WebCmsComponentModelAdminRenderService(EntityViewElementBuilderHelper builderHelper, WebCmsComponentRepository componentRepository) {
        this.builderHelper = builderHelper;
        this.componentRepository = componentRepository;
    }
}

