/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.core.support.ReadableAttributes;
import com.foreach.across.modules.bootstrapui.styles.AcrossBootstrapStyles;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.entity.support.EntityMessageCodeResolver;
import com.foreach.across.modules.web.ui.DefaultViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import com.foreach.across.modules.web.ui.elements.builder.AbstractNodeViewElementBuilder;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import org.apache.commons.lang3.StringUtils;

public final class WebCmsComponentModelFormElementBuilder
extends AbstractNodeViewElementBuilder<WebCmsComponentModelFormElement, WebCmsComponentModelFormElementBuilder> {
    public static final String COMPONENT_MESSAGE_CODE_PREFIX = WebCmsComponentModelFormElement.class.getName() + ".messageCodePrefix";
    private final WebCmsComponentModel componentModel;
    private ViewElementBuilder contentViewElementBuilder;
    private ViewElementBuilder membersViewElementBuilder;
    private ViewElementBuilder settingsViewElementBuilder;
    private ViewElementBuilder metadataViewElementBuilder;

    public WebCmsComponentModelFormElementBuilder(WebCmsComponentModel componentModel) {
        this.componentModel = componentModel;
        this.customTemplate("th/webCmsModule/admin/fragments :: componentModelFormElement(${component},${component.componentModel})");
        this.name("formControl-" + componentModel.getName());
        this.attribute("componentModel", componentModel);
        this.htmlId(componentModel.getObjectId());
        this.showSettings(true);
    }

    public WebCmsComponentModelFormElementBuilder showDeleteButton(boolean showButton) {
        this.attribute("showDeleteButton", showButton);
        return this;
    }

    public WebCmsComponentModelFormElementBuilder showAddComponentButton(boolean showButton) {
        this.attribute("showAddComponentButton", showButton);
        return this;
    }

    public WebCmsComponentModelFormElementBuilder showAsLinkedComponent(boolean linkedComponent) {
        this.attribute("showAsLinkedComponent", linkedComponent);
        return this;
    }

    public WebCmsComponentModelFormElementBuilder sortableContainer(boolean sortable) {
        this.attribute("sortableContainer", sortable);
        return this;
    }

    public WebCmsComponentModelFormElementBuilder members(ViewElementBuilder membersViewElementBuilder) {
        this.membersViewElementBuilder = membersViewElementBuilder;
        return this;
    }

    public WebCmsComponentModelFormElementBuilder content(ViewElementBuilder contentViewElementBuilder) {
        this.contentViewElementBuilder = contentViewElementBuilder;
        return this;
    }

    public WebCmsComponentModelFormElementBuilder settings(ViewElementBuilder settingsViewElementBuilder) {
        this.settingsViewElementBuilder = settingsViewElementBuilder;
        return this;
    }

    public WebCmsComponentModelFormElementBuilder metadata(ViewElementBuilder metadataViewElementBuilder) {
        this.metadataViewElementBuilder = metadataViewElementBuilder;
        return this;
    }

    public WebCmsComponentModelFormElementBuilder showSettings(boolean showSettings) {
        this.attribute("showSettings", showSettings);
        return this;
    }

    protected WebCmsComponentModelFormElement createElement(ViewElementBuilderContext parentBuilderContext) {
        DefaultViewElementBuilderContext builderContext = new DefaultViewElementBuilderContext((ReadableAttributes)parentBuilderContext);
        WebCmsComponentModelFormElement element = new WebCmsComponentModelFormElement();
        EntityMessageCodeResolver codeResolver = (EntityMessageCodeResolver)builderContext.getAttribute(EntityMessageCodeResolver.class);
        String messageCodePrefix = StringUtils.defaultString((String)((String)builderContext.getAttribute(COMPONENT_MESSAGE_CODE_PREFIX, String.class)));
        messageCodePrefix = messageCodePrefix.isEmpty() ? this.componentModel.getComponentType().getTypeKey() : messageCodePrefix + ".members." + this.componentModel.getName();
        builderContext.setAttribute(COMPONENT_MESSAGE_CODE_PREFIX, (Object)messageCodePrefix);
        EntityMessageCodeResolver newCodeResolver = new EntityMessageCodeResolver(codeResolver);
        newCodeResolver.addPrefixes(new String[]{"webCmsComponents"});
        builderContext.setAttribute(EntityMessageCodeResolver.class, (Object)newCodeResolver);
        if (this.contentViewElementBuilder != null) {
            element.setContent(this.applyDescription(this.contentViewElementBuilder.build((ViewElementBuilderContext)builderContext), messageCodePrefix + ".content", newCodeResolver));
        }
        if (this.membersViewElementBuilder != null) {
            element.setMembers(this.applyDescription(this.membersViewElementBuilder.build((ViewElementBuilderContext)builderContext), messageCodePrefix + ".members", newCodeResolver));
        }
        if (this.metadataViewElementBuilder != null) {
            element.setMetadata(this.applyDescription(this.metadataViewElementBuilder.build((ViewElementBuilderContext)builderContext), messageCodePrefix + ".metadata", newCodeResolver));
        }
        if (this.settingsViewElementBuilder != null) {
            element.setSettings(this.applyDescription(this.settingsViewElementBuilder.build((ViewElementBuilderContext)builderContext), messageCodePrefix + ".settings", newCodeResolver));
        }
        return (WebCmsComponentModelFormElement)this.apply(element, (ViewElementBuilderContext)builderContext);
    }

    private ViewElement applyDescription(ViewElement original, String messageCodePrefix, EntityMessageCodeResolver codeResolver) {
        String descriptionText = codeResolver.getMessageWithFallback(messageCodePrefix + "[description]", "");
        String additionalDescriptionText = codeResolver.getMessageWithFallback(messageCodePrefix + "[additionalDescription]", "");
        if (StringUtils.isNotEmpty((CharSequence)descriptionText) || StringUtils.isNotEmpty((CharSequence)additionalDescriptionText)) {
            NodeViewElement helpBlock;
            ContainerViewElement container = new ContainerViewElement();
            if (StringUtils.isNotEmpty((CharSequence)descriptionText)) {
                helpBlock = new NodeViewElement("p");
                helpBlock.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.form.text, AcrossBootstrapStyles.css.text.muted, AcrossBootstrapStyles.css.margin.bottom.s1});
                helpBlock.addCssClass(new String[]{"help-block", "description-block"});
                helpBlock.addChild((ViewElement)TextViewElement.html((String)descriptionText));
                container.addChild((ViewElement)helpBlock);
            }
            container.addChild(original);
            if (StringUtils.isNotEmpty((CharSequence)additionalDescriptionText)) {
                helpBlock = new NodeViewElement("p");
                helpBlock.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.form.text, AcrossBootstrapStyles.css.text.muted, AcrossBootstrapStyles.css.margin.bottom.s1});
                helpBlock.addCssClass(new String[]{"help-block", "description-block-additional"});
                helpBlock.addChild((ViewElement)TextViewElement.html((String)additionalDescriptionText));
                container.addChild((ViewElement)helpBlock);
            }
            return container;
        }
        return original;
    }

    static class WebCmsComponentModelFormElement
    extends AbstractNodeViewElement {
        private ViewElement content;
        private ViewElement settings;
        private ViewElement metadata;
        private ViewElement members;

        private WebCmsComponentModelFormElement() {
            super("div");
        }

        public WebCmsComponentModel getComponentModel() {
            return (WebCmsComponentModel)this.getAttribute("componentModel", WebCmsComponentModel.class);
        }

        public boolean isShowDeleteButton() {
            return Boolean.TRUE.equals(this.getAttribute("showDeleteButton"));
        }

        public boolean isShowAddComponentButton() {
            return Boolean.TRUE.equals(this.getAttribute("showAddComponentButton"));
        }

        public boolean isSortableContainer() {
            return Boolean.TRUE.equals(this.getAttribute("sortableContainer"));
        }

        public boolean isShowSettings() {
            return Boolean.TRUE.equals(this.getAttribute("showSettings"));
        }

        public boolean isShowAsLinkedComponent() {
            return Boolean.TRUE.equals(this.getAttribute("showAsLinkedComponent"));
        }

        public boolean hasMembers() {
            return !this.isShowAsLinkedComponent() && this.members != null;
        }

        public boolean hasContent() {
            return !this.isShowAsLinkedComponent() && this.content != null;
        }

        public boolean hasSettings() {
            return !this.isShowAsLinkedComponent() && this.isShowSettings() && this.settings != null;
        }

        public boolean hasMetadata() {
            return !this.isShowAsLinkedComponent() && this.metadata != null;
        }

        public String getLabel() {
            WebCmsComponentModel componentModel = this.getComponentModel();
            return (String)StringUtils.defaultIfBlank((CharSequence)componentModel.getTitle(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)componentModel.getName(), (CharSequence)componentModel.getComponentType().getName()));
        }

        public void setContent(ViewElement content) {
            this.content = content;
        }

        public void setSettings(ViewElement settings) {
            this.settings = settings;
        }

        public void setMetadata(ViewElement metadata) {
            this.metadata = metadata;
        }

        public void setMembers(ViewElement members) {
            this.members = members;
        }

        public ViewElement getContent() {
            return this.content;
        }

        public ViewElement getSettings() {
            return this.settings;
        }

        public ViewElement getMetadata() {
            return this.metadata;
        }

        public ViewElement getMembers() {
            return this.members;
        }
    }
}

