/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.web;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.bootstrapui.elements.FormViewElement;
import com.foreach.across.modules.bootstrapui.elements.builder.ColumnViewElementBuilder;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.support.ViewElementBuilderMap;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.web.links.SingleEntityViewLinkBuilder;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilderSupport;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelAdminRenderService;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentModelFormElementBuilder;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentUpdateLinkBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

@Component
@Exposed
@Scope(value="prototype")
@ConditionalOnAdminUI
public class WebCmsComponentsFormProcessor
extends EntityViewProcessorAdapter {
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsComponentModelService componentModelService;
    private final WebCmsComponentModelAdminRenderService componentModelAdminRenderService;
    private String[] componentNames = new String[0];
    private boolean renderMembersIfContainer = true;

    public void setComponentNames(String ... componentNames) {
        this.componentNames = componentNames;
    }

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        WebCmsObject owner = (WebCmsObject)command.getEntity(WebCmsObject.class);
        String componentObjectId = entityViewRequest.getWebRequest().getParameter("componentObjectId");
        command.addExtension("webCmsComponents", (Object)new ModelsHolder((WebCmsComponentModel[])Stream.of(this.componentNames).map(componentName -> this.componentModelService.getComponentModelByName((String)componentName, owner)).flatMap(model -> {
            if (model instanceof ContainerWebCmsComponentModel && this.renderMembersIfContainer) {
                return ((ContainerWebCmsComponentModel)model).getMembers().stream();
            }
            return Stream.of(model);
        }).filter(Objects::nonNull).toArray(WebCmsComponentModel[]::new)));
        if (componentObjectId != null) {
            entityViewRequest.getModel().addAttribute("configuredWebCmsComponents", command.getExtension("webCmsComponents"));
            command.addExtension("webCmsComponents", (Object)new ModelsHolder(new WebCmsComponentModel[]{this.componentModelService.getComponentModel(componentObjectId)}));
            command.addExtension("singleComponent", (Object)Boolean.TRUE);
        }
    }

    protected void doControl(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult, HttpMethod httpMethod) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        entityView.addAttribute("currentComponentUrl", (Object)pathHelper.getPathWithinApplication((HttpServletRequest)entityViewRequest.getWebRequest().getNativeRequest(HttpServletRequest.class)));
        entityView.addAttribute("componentLinkBuilder", component -> (SingleEntityViewLinkBuilder)entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance(entityViewRequest.getEntityViewContext().getEntity()).updateView().withQueryParam("componentObjectId", new Object[]{component.getObjectId()}));
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            ModelsHolder componentModels = (ModelsHolder)command.getExtension("webCmsComponents", ModelsHolder.class);
            Arrays.stream(componentModels.models).forEach(this.componentModelService::save);
            entityView.setRedirectUrl(ServletUriComponentsBuilder.fromCurrentRequest().toUriString());
        }
    }

    protected void render(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElementBuilderSupport<?, ?> containerBuilder, ViewElementBuilderMap builderMap, ViewElementBuilderContext builderContext) {
        EntityViewCommand command = entityViewRequest.getCommand();
        ModelsHolder componentModels = (ModelsHolder)command.getExtension("webCmsComponents", ModelsHolder.class);
        ColumnViewElementBuilder columnViewElementBuilder = (ColumnViewElementBuilder)builderMap.get("entityForm-column-0", ColumnViewElementBuilder.class);
        WebCmsComponentUpdateLinkBuilder componentLinkBuilder = (WebCmsComponentUpdateLinkBuilder)entityView.getAttribute("componentLinkBuilder", WebCmsComponentUpdateLinkBuilder.class);
        if (this.isSingleComponent(command)) {
            WebCmsComponentModel componentModel = componentModels.models[0];
            NodeViewElementBuilder ownerTrail = HtmlViewElements.html.builders.ul(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.css((String[])new String[]{"breadcrumb", "wcm-component-owner-trail"})});
            String baseUrl = entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance(entityViewRequest.getEntityViewContext().getEntity()).updateView().toUriString();
            WebCmsObject root = (WebCmsObject)entityViewRequest.getEntityViewContext().getEntity(WebCmsObject.class);
            ModelsHolder rootComponents = (ModelsHolder)entityView.getAttribute("configuredWebCmsComponents", ModelsHolder.class);
            if (this.addToOwnerTrail(ownerTrail, componentModel.getObjectId(), componentLinkBuilder, rootComponents, root, baseUrl, false)) {
                columnViewElementBuilder.add(new ViewElementBuilder[]{ownerTrail});
            }
        }
        for (int i = 0; i < componentModels.models.length; ++i) {
            WebCmsComponentModelFormElementBuilder formElement = this.componentModelAdminRenderService.createFormElement(componentModels.models[i], "extensions[webCmsComponents].models[" + i + "]");
            formElement.showSettings(false);
            columnViewElementBuilder.add(new ViewElementBuilder[]{formElement});
        }
    }

    private boolean addToOwnerTrail(NodeViewElementBuilder breadcrumb, String objectId, WebCmsComponentUpdateLinkBuilder linkBuilder, ModelsHolder rootComponents, WebCmsObject root, String baseUrl, boolean createLink) {
        WebCmsComponent owner = this.componentRepository.findOneByObjectId(objectId).orElse(null);
        if (owner != null) {
            boolean linkToRoot = owner.hasOwner() && owner.getOwnerObjectId().equals(root.getObjectId()) || rootComponents.contains(owner);
            String title = (String)StringUtils.defaultIfBlank((CharSequence)owner.getTitle(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)owner.getName(), (CharSequence)owner.getComponentType().getName()));
            breadcrumb.addFirst(new ViewElementBuilder[]{((NodeViewElementBuilder)((NodeViewElementBuilder)HtmlViewElements.html.builders.li().attribute("title", (Object)owner.getName())).with(new ViewElement.WitherSetter[]{BootstrapStyles.css.breadcrumb.item})).add(new ViewElementBuilder[]{createLink ? BootstrapViewElements.bootstrap.builders.link().url(linkToRoot ? baseUrl : linkBuilder.update(owner).withFromUrl(baseUrl).toUriString()).text(title) : HtmlViewElements.html.builders.text(title)})});
            if (owner.hasOwner() && !linkToRoot) {
                return this.addToOwnerTrail(breadcrumb, owner.getOwnerObjectId(), linkBuilder, rootComponents, root, baseUrl, true) || createLink;
            }
            return createLink;
        }
        return false;
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        container.find("entityForm", FormViewElement.class).ifPresent(form -> {
            String qs = StringUtils.defaultString((String)((HttpServletRequest)entityViewRequest.getWebRequest().getNativeRequest(HttpServletRequest.class)).getQueryString());
            form.setAction("?" + UriUtils.decode((String)qs, (String)"UTF-8"));
        });
        if (this.isSingleComponent(entityViewRequest.getCommand())) {
            container.find("entityForm-column-1", ContainerViewElement.class).ifPresent(ContainerViewElement::clearChildren);
        }
    }

    private boolean isSingleComponent(EntityViewCommand command) {
        return Boolean.TRUE.equals(command.getExtension("singleComponent", Boolean.class));
    }

    protected void registerWebResources(EntityViewRequest entityViewRequest, EntityView entityView, WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"wcm-components-admin"});
    }

    public WebCmsComponentsFormProcessor(WebCmsComponentRepository componentRepository, WebCmsComponentModelService componentModelService, WebCmsComponentModelAdminRenderService componentModelAdminRenderService) {
        this.componentRepository = componentRepository;
        this.componentModelService = componentModelService;
        this.componentModelAdminRenderService = componentModelAdminRenderService;
    }

    public void setRenderMembersIfContainer(boolean renderMembersIfContainer) {
        this.renderMembersIfContainer = renderMembersIfContainer;
    }

    static class ModelsHolder {
        @Valid
        private final WebCmsComponentModel[] models;

        boolean contains(WebCmsComponent component) {
            return Arrays.stream(this.models).anyMatch(m -> component.getObjectId().equals(m.getObjectId()));
        }

        public ModelsHolder(WebCmsComponentModel[] models) {
            this.models = models;
        }

        public WebCmsComponentModel[] getModels() {
            return this.models;
        }
    }
}

