/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.entity.query.EQType;
import com.foreach.across.modules.entity.query.EQTypeConverter;
import com.foreach.across.modules.entity.query.EntityQuery;
import com.foreach.across.modules.entity.query.EntityQueryCondition;
import com.foreach.across.modules.entity.query.EntityQueryConditionTranslator;
import com.foreach.across.modules.entity.query.EntityQueryExpression;
import com.foreach.across.modules.entity.query.EntityQueryFunctionHandler;
import com.foreach.across.modules.entity.query.EntityQueryOps;
import com.foreach.across.modules.spring.security.actions.AllowableAction;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainAdminUiService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Component
@Lazy
public final class EntityQueryWebCmsDomainFunctions
implements EntityQueryFunctionHandler {
    public static final String SELECTED_DOMAIN = "selectedDomain";
    public static final String VISIBLE_DOMAINS = "visibleDomains";
    public static final String ACCESSIBLE_DOMAINS = "accessibleDomains";
    private static final EntityQueryConditionTranslator DOMAIN_CONDITION_TRANSLATOR = condition -> {
        boolean negation;
        boolean translatable = EntityQueryOps.EQ.equals((Object)condition.getOperand()) || EntityQueryOps.IN.equals((Object)condition.getOperand());
        boolean bl = negation = EntityQueryOps.NEQ.equals((Object)condition.getOperand()) || EntityQueryOps.NOT_IN.equals((Object)condition.getOperand());
        if (translatable || negation) {
            List domains = Stream.of(condition.getArguments()).flatMap(argument -> argument instanceof Object[] ? Stream.of((Object[])argument) : Stream.of(argument)).collect(Collectors.toList());
            boolean nullIncluded = domains.remove(null);
            EntityQueryCondition domainCondition = null;
            EntityQueryCondition nullCondition = null;
            if (domains.size() > 0) {
                domainCondition = domains.size() > 1 ? new EntityQueryCondition(condition.getProperty(), negation ? EntityQueryOps.NOT_IN : EntityQueryOps.IN, domains.toArray()) : new EntityQueryCondition(condition.getProperty(), negation ? EntityQueryOps.NEQ : EntityQueryOps.EQ, domains.toArray());
            }
            if (nullIncluded) {
                nullCondition = new EntityQueryCondition(condition.getProperty(), negation ? EntityQueryOps.IS_NOT_NULL : EntityQueryOps.IS_NULL, new Object[0]);
            }
            if (nullCondition != null && domainCondition != null) {
                return negation ? EntityQuery.and((EntityQueryExpression[])new EntityQueryExpression[]{domainCondition, nullCondition}) : EntityQuery.or((EntityQueryExpression[])new EntityQueryExpression[]{domainCondition, nullCondition});
            }
            if (nullCondition != null) {
                return nullCondition;
            }
            return domainCondition;
        }
        return condition;
    };
    private final WebCmsMultiDomainAdminUiService multiDomainAdminUiService;

    public static EntityQueryConditionTranslator conditionTranslator() {
        return DOMAIN_CONDITION_TRANSLATOR;
    }

    public boolean accepts(String functionName, TypeDescriptor desiredType) {
        return SELECTED_DOMAIN.equals(functionName) || VISIBLE_DOMAINS.equals(functionName) || ACCESSIBLE_DOMAINS.equals(functionName);
    }

    public Object apply(String functionName, EQType[] arguments, TypeDescriptor desiredType, EQTypeConverter argumentConverter) {
        return this.retrieveDomains(functionName, arguments, argumentConverter).stream().map(domain -> this.convertDomainToType((WebCmsDomain)domain, desiredType, argumentConverter)).collect(Collectors.toList()).toArray();
    }

    private Object convertDomainToType(WebCmsDomain domain, TypeDescriptor desiredType, EQTypeConverter argumentConverter) {
        Class targetType = desiredType.getObjectType();
        if (domain != null) {
            if (WebCmsDomain.class.equals((Object)targetType)) {
                return domain;
            }
            if (String.class.equals((Object)targetType)) {
                return domain.getObjectId();
            }
            if (Long.class.equals((Object)targetType) || Long.TYPE.equals(targetType)) {
                return domain.getId();
            }
            return argumentConverter.convert(desiredType, (Object)domain);
        }
        return null;
    }

    private Collection<WebCmsDomain> retrieveDomains(String functionName, EQType[] arguments, EQTypeConverter argumentConverter) {
        switch (functionName) {
            case "visibleDomains": {
                return this.multiDomainAdminUiService.getVisibleDomains();
            }
            case "accessibleDomains": {
                AllowableAction[] actions = new AllowableAction[]{AllowableAction.READ};
                if (arguments.length > 0) {
                    actions = Stream.of(arguments).map(a -> new AllowableAction((String)argumentConverter.convert(TypeDescriptor.valueOf(String.class), a))).collect(Collectors.toList()).toArray(new AllowableAction[arguments.length]);
                }
                return this.multiDomainAdminUiService.getAccessibleDomains(actions);
            }
            case "selectedDomain": {
                return Collections.singleton(this.multiDomainAdminUiService.getSelectedDomain());
            }
        }
        return Collections.emptyList();
    }

    public EntityQueryWebCmsDomainFunctions(WebCmsMultiDomainAdminUiService multiDomainAdminUiService) {
        this.multiDomainAdminUiService = multiDomainAdminUiService;
    }
}

