/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainService;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.stereotype.Component;

@Component
public class StringToWebCmsDomainConverter
implements Converter<String, WebCmsDomain> {
    private final WebCmsDomainService domainService;
    private final WebCmsDomainRepository domainRepository;

    @Autowired
    void registerToConversionService(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(this);
    }

    @Autowired
    void registerToMvcConversionService(@Qualifier(value="mvcConversionService") ConverterRegistry mvcConversionService) {
        mvcConversionService.addConverter((Converter)this);
    }

    public WebCmsDomain convert(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return this.domainRepository.findById(Long.parseLong(value)).orElse(null);
        }
        if (WebCmsUtils.isObjectIdForCollection(value, "wcm:domain")) {
            return this.domainService.getDomain(value);
        }
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return this.domainService.getDomainByKey(value);
        }
        return null;
    }

    public StringToWebCmsDomainConverter(WebCmsDomainService domainService, WebCmsDomainRepository domainRepository) {
        this.domainService = domainService;
        this.domainRepository = domainRepository;
    }
}

