/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.hibernate.business.SettableIdAuditableEntity;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SortNatural;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_domain")
@Access(value=AccessType.FIELD)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NotThreadSafe
public class WebCmsDomain
extends SettableIdAuditableEntity<WebCmsDomain>
implements WebCmsObject {
    public static final WebCmsDomain NONE = null;
    public static final String NO_DOMAIN_KEY = null;
    public static final String COLLECTION_ID = "wcm:domain";
    @Id
    @GeneratedValue(generator="seq_wcm_domain_id")
    @GenericGenerator(name="seq_wcm_domain_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_domain_id"), @Parameter(name="allocationSize", value="1")})
    private Long id;
    @Column(name="object_id", unique=true)
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String objectId;
    @Column(name="name")
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String name;
    @Column(name="domain_key")
    @NotBlank
    @Length(max=255)
    @Pattern(regexp="^[\\p{Alnum}-_.]*$")
    private @NotBlank @Length(max=255) @Pattern(regexp="^[\\p{Alnum}-_.]*$") String domainKey;
    @Column(name="description")
    @Length(max=500)
    private @Length(max=500) String description;
    @ElementCollection(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    @CollectionTable(name="wcm_domain_attributes", joinColumns={@JoinColumn(name="type_id")})
    @MapKeyColumn(name="attribute_key")
    @Column(name="attribute_value")
    @SortNatural
    private SortedMap<String, String> attributes = new TreeMap<String, String>();
    @Column(name="active")
    private boolean active = true;

    public WebCmsDomain() {
    }

    public WebCmsDomain(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String name, String domainKey, String description, Map<String, String> attributes, boolean active) {
        this.setNewEntityId(newEntityId);
        this.setId(id);
        this.setCreatedBy(createdBy);
        this.setCreatedDate(createdDate);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDate(lastModifiedDate);
        this.setName(name);
        this.setObjectId(objectId);
        this.setDomainKey(domainKey);
        this.setDescription(description);
        this.setActive(active);
        this.attributes = new TreeMap<String, String>(attributes);
    }

    public static boolean isNoDomain(WebCmsDomain domain) {
        return domain == null;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = StringUtils.isEmpty((CharSequence)objectId) ? null : WebCmsUtils.prefixObjectIdForCollection(objectId, COLLECTION_ID);
    }

    public void setDomainKey(String domainKey) {
        this.domainKey = domainKey;
        if (this.getObjectId() == null && StringUtils.isNotEmpty((CharSequence)domainKey)) {
            this.setObjectId(domainKey);
        }
    }

    public final String getAttribute(String attributeKey) {
        return (String)this.getAttributes().get(attributeKey);
    }

    public final String getAttribute(String attributeKey, String defaultValue) {
        return this.getAttributes().getOrDefault(attributeKey, defaultValue);
    }

    public boolean hasAttribute(String attributeKey) {
        return this.getAttributes().containsKey(attributeKey);
    }

    public String toString() {
        return "WebCmsDomain{objectId='" + this.getObjectId() + "',domainKey='" + this.domainKey + '\'' + '}';
    }

    public static WebCmsDomainBuilder builder() {
        return new WebCmsDomainBuilder();
    }

    public WebCmsDomainBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        boolean active = this.isActive();
        WebCmsDomainBuilder builder = new WebCmsDomainBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).name(this.name).domainKey(this.domainKey).description(this.description).active(active);
        if (this.attributes != null) {
            builder.attributes(this.attributes);
        }
        return builder;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    public String getDescription() {
        return this.description;
    }

    public SortedMap<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAttributes(SortedMap<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static class WebCmsDomainBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private String name;
        private String domainKey;
        private String description;
        private ArrayList<String> attributes$key;
        private ArrayList<String> attributes$value;
        private boolean active = true;

        WebCmsDomainBuilder() {
        }

        public WebCmsDomainBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsDomainBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsDomainBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsDomainBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsDomainBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsDomainBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsDomainBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsDomainBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WebCmsDomainBuilder domainKey(String domainKey) {
            this.domainKey = domainKey;
            return this;
        }

        public WebCmsDomainBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WebCmsDomainBuilder attribute(String attributeKey, String attributeValue) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            this.attributes$key.add(attributeKey);
            this.attributes$value.add(attributeValue);
            return this;
        }

        public WebCmsDomainBuilder attributes(Map<? extends String, ? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : attributes.entrySet()) {
                this.attributes$key.add($lombokEntry.getKey());
                this.attributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public WebCmsDomainBuilder clearAttributes() {
            if (this.attributes$key != null) {
                this.attributes$key.clear();
                this.attributes$value.clear();
            }
            return this;
        }

        public WebCmsDomainBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        public WebCmsDomain build() {
            Map<Object, Object> attributes;
            switch (this.attributes$key == null ? 0 : this.attributes$key.size()) {
                case 0: {
                    attributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonMap(this.attributes$key.get(0), this.attributes$value.get(0));
                    break;
                }
                default: {
                    attributes = new LinkedHashMap(this.attributes$key.size() < 0x40000000 ? 1 + this.attributes$key.size() + (this.attributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attributes$key.size(); ++$i) {
                        attributes.put(this.attributes$key.get($i), this.attributes$value.get($i));
                    }
                    attributes = Collections.unmodifiableMap(attributes);
                }
            }
            return new WebCmsDomain(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.name, this.domainKey, this.description, attributes, this.active);
        }

        public String toString() {
            return "WebCmsDomain.WebCmsDomainBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", name=" + this.name + ", domainKey=" + this.domainKey + ", description=" + this.description + ", attributes$key=" + this.attributes$key + ", attributes$value=" + this.attributes$value + ", active=" + this.active + ")";
        }
    }
}

