/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.PostRefresh;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainMetadataFactory;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.stereotype.Component;

@Exposed
@Component
public class WebCmsDomainCache {
    private static final Cache DEFAULT_CACHE = new NoOpCache("WebCmsDomainCache");
    private static final String LOOKUP_DATA_KEY = "lookupData";
    private final CacheManager cacheManager;
    private final WebCmsDomainMetadataFactory metadataFactory;
    private final WebCmsDomainRepository domainRepository;
    private Cache cache = DEFAULT_CACHE;

    public Object getMetadataForDomain(WebCmsDomain domain) {
        long domainId = WebCmsDomain.isNoDomain(domain) ? 0L : domain.getId();
        return this.cache.get((Object)("metadata:" + domainId), () -> this.metadataFactory.createMetadataForDomain(domain));
    }

    public WebCmsDomain getDomain(String objectId) {
        return (WebCmsDomain)this.cache.get((Object)objectId, () -> {
            WebCmsDomain domain = this.domainRepository.findOneByObjectId(objectId).orElse(null);
            if (domain != null) {
                this.cache.put((Object)("key:" + domain.getDomainKey()), (Object)domain);
            }
            return domain;
        });
    }

    public WebCmsDomain getDomainByKey(String domainKey) {
        return (WebCmsDomain)this.cache.get((Object)("key:" + domainKey), () -> {
            WebCmsDomain domain = this.domainRepository.findOneByDomainKey(domainKey).orElse(null);
            if (domain != null) {
                this.cache.put((Object)domain.getObjectId(), (Object)domain);
            }
            return domain;
        });
    }

    public void put(WebCmsDomain domain) {
        this.cache.put((Object)domain.getObjectId(), (Object)domain);
        this.cache.put((Object)("key:" + domain.getDomainKey()), (Object)domain);
        this.cache.evict((Object)("metadata:" + domain.getId()));
        this.cache.evict((Object)LOOKUP_DATA_KEY);
    }

    public void evict(WebCmsDomain domain) {
        this.cache.evict((Object)domain.getObjectId());
        this.cache.evict((Object)("key:" + domain.getDomainKey()));
        this.cache.evict((Object)("metadata:" + domain.getId()));
        this.cache.evict((Object)LOOKUP_DATA_KEY);
    }

    public void putLookupData(Object lookupData) {
        this.cache.put((Object)LOOKUP_DATA_KEY, lookupData);
    }

    public <T> T getLookupData(Class<T> expectedType) {
        return (T)this.cache.get((Object)LOOKUP_DATA_KEY, expectedType);
    }

    public void evictLookupData() {
        this.cache.evict((Object)LOOKUP_DATA_KEY);
    }

    @PostRefresh
    public void reloadCache() {
        Cache candidate = this.cacheManager.getCache("WebCmsDomainCache");
        this.cache = candidate != null ? (candidate instanceof TransactionAwareCacheDecorator ? candidate : new TransactionAwareCacheDecorator(candidate)) : DEFAULT_CACHE;
    }

    public WebCmsDomainCache(CacheManager cacheManager, WebCmsDomainMetadataFactory metadataFactory, WebCmsDomainRepository domainRepository) {
        this.cacheManager = cacheManager;
        this.metadataFactory = metadataFactory;
        this.domainRepository = domainRepository;
    }
}

