/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public final class WebCmsDomainContext {
    private final WebCmsDomain domain;
    private final Object metadata;

    public WebCmsDomainContext(WebCmsDomain domain, Object metadata) {
        Assert.notNull((Object)domain, (String)"Unable to create a WebCmsDomainContext without a domain.");
        this.domain = domain;
        this.metadata = metadata;
    }

    private WebCmsDomainContext(Object metadata) {
        this.domain = null;
        this.metadata = metadata;
    }

    public static WebCmsDomainContext noDomain() {
        return WebCmsDomainContext.noDomain(null);
    }

    public static WebCmsDomainContext noDomain(Object metadata) {
        return new WebCmsDomainContext(metadata);
    }

    public <T> T getMetadata(Class<T> expectedType) {
        return expectedType.cast(this.metadata);
    }

    public boolean isMetadataOfType(Class<?> expectedType) {
        return expectedType.isInstance(this.metadata);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean holdsDomain() {
        return this.domain != null;
    }

    public boolean holdsDomain(String domainKey) {
        if (domainKey == null) {
            return this.isNoDomain();
        }
        return this.domain != null && StringUtils.equals((CharSequence)domainKey, (CharSequence)this.domain.getDomainKey());
    }

    public boolean isNoDomain() {
        return !this.holdsDomain();
    }

    public WebCmsDomain getDomain() {
        return this.domain;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebCmsDomainContext)) {
            return false;
        }
        WebCmsDomainContext other = (WebCmsDomainContext)o;
        WebCmsDomain this$domain = this.getDomain();
        WebCmsDomain other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        Object this$metadata = this.getMetadata();
        Object other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebCmsDomain $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        Object $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "WebCmsDomainContext(domain=" + this.getDomain() + ", metadata=" + this.getMetadata() + ")";
    }
}

