/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.validators.WebCmsDomainValidator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsDomainImporter
extends AbstractWebCmsDataImporter<WebCmsDomain, WebCmsDomain> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDomainImporter.class);
    private final WebCmsDomainRepository domainRepository;
    private final WebCmsDomainValidator domainValidator;

    @Override
    public boolean supports(WebCmsDataEntry data) {
        return "domains".equals(data.getParentKey());
    }

    @Override
    protected WebCmsDomain retrieveExistingInstance(WebCmsDataEntry data) {
        String domainKey = data.getMapData().containsKey("domainKey") ? (String)data.getMapData().get("domainKey") : data.getKey();
        String objectId = (String)data.getMapData().get("objectId");
        WebCmsDomain existing = null;
        if (objectId != null) {
            existing = this.domainRepository.findOneByObjectId(objectId).orElse(null);
        }
        return existing != null ? existing : (WebCmsDomain)this.domainRepository.findOneByDomainKey(domainKey).orElse(null);
    }

    @Override
    protected WebCmsDomain createDto(WebCmsDataEntry data, WebCmsDomain existing, WebCmsDataAction action, Map<String, Object> dataValues) {
        if (existing == null) {
            return this.createNewDomainDto(data);
        }
        if (action == WebCmsDataAction.REPLACE) {
            WebCmsDomain dto = this.createNewDomainDto(data);
            dto.setId(existing.getId());
            dto.setObjectId(existing.getObjectId());
            return dto;
        }
        return (WebCmsDomain)existing.toDto();
    }

    private WebCmsDomain createNewDomainDto(WebCmsDataEntry data) {
        String dataKey = data.getMapData().containsKey("domainKey") ? (String)data.getMapData().get("domainKey") : data.getKey();
        return WebCmsDomain.builder().domainKey(dataKey).build();
    }

    @Override
    protected void deleteInstance(WebCmsDomain instance, WebCmsDataEntry data) {
        this.domainRepository.delete(instance);
    }

    @Override
    protected void saveDto(WebCmsDomain dto, WebCmsDataAction action, WebCmsDataEntry data) {
        LOG.debug("Saving WebCmsDomain {} with objectId {} (insert: {}) - {}", new Object[]{dto.getClass().getSimpleName(), dto.getObjectId(), dto.isNew(), dto});
        this.domainRepository.save(dto);
    }

    @Override
    protected void validate(WebCmsDomain itemToBeSaved, Errors errors) {
        this.domainValidator.validate(itemToBeSaved, errors);
    }

    public WebCmsDomainImporter(WebCmsDomainRepository domainRepository, WebCmsDomainValidator domainValidator) {
        this.domainRepository = domainRepository;
        this.domainValidator = domainValidator;
    }
}

