/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainAware;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainMetadataFactory;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class WebCmsDomainMetadataFactoryImpl
implements WebCmsDomainMetadataFactory {
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
    private final AutowireCapableBeanFactory beanFactory;

    @Override
    public Object createMetadataForDomain(WebCmsDomain domain) {
        if (domain == null) {
            String noDomainMetadataBeanName = this.multiDomainConfiguration.getNoDomainMetadataBeanName();
            return noDomainMetadataBeanName != null ? this.beanFactory.getBean(noDomainMetadataBeanName) : null;
        }
        Class<? extends WebCmsDomainAware> metadataClass = this.multiDomainConfiguration.getMetadataClass();
        if (metadataClass != null) {
            WebCmsDomainAware metadata = (WebCmsDomainAware)this.beanFactory.createBean(metadataClass);
            metadata.setWebCmsDomain(domain);
            return metadata;
        }
        return null;
    }

    public WebCmsDomainMetadataFactoryImpl(WebCmsMultiDomainConfiguration multiDomainConfiguration, AutowireCapableBeanFactory beanFactory) {
        this.multiDomainConfiguration = multiDomainConfiguration;
        this.beanFactory = beanFactory;
    }
}

