/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.spring.security.actions.AllowableAction;
import com.foreach.across.modules.spring.security.actions.AllowableActions;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.domain.QWebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContextHolder;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.stereotype.Service;

@ConditionalOnAdminUI
@Service
public class WebCmsMultiDomainAdminUiService {
    private final EntityRegistry entityRegistry;
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
    private final WebCmsDomainRepository domainRepository;

    public WebCmsDomain getSelectedDomain() {
        WebCmsDomainContext domainContext = WebCmsDomainContextHolder.getWebCmsDomainContext();
        return domainContext != null ? domainContext.getDomain() : null;
    }

    public Collection<WebCmsDomain> getVisibleDomains() {
        ArrayList<WebCmsDomain> domains = new ArrayList<WebCmsDomain>(2);
        WebCmsDomain selectedDomain = this.getSelectedDomain();
        if (selectedDomain != null) {
            domains.add(selectedDomain);
        }
        if (this.multiDomainConfiguration.isNoDomainAllowed()) {
            domains.add(null);
        }
        return domains;
    }

    public Collection<WebCmsDomain> getAccessibleDomains(AllowableAction ... actions) {
        AllowableAction[] allowableActionArray;
        EntityConfiguration configuration = this.entityRegistry.getEntityConfiguration(WebCmsDomain.class);
        if (actions.length > 0) {
            allowableActionArray = actions;
        } else {
            AllowableAction[] allowableActionArray2 = new AllowableAction[1];
            allowableActionArray = allowableActionArray2;
            allowableActionArray2[0] = AllowableAction.READ;
        }
        AllowableAction[] actionsToCheck = allowableActionArray;
        ArrayList<WebCmsDomain> domains = new ArrayList<WebCmsDomain>();
        if (this.multiDomainConfiguration.isNoDomainAllowed() && this.containsAny(configuration.getAllowableActions(), actionsToCheck)) {
            domains.add(null);
        }
        this.domainRepository.findAll().stream().filter(d -> this.containsAny(configuration.getAllowableActions(d), actionsToCheck)).forEach(domains::add);
        return domains;
    }

    private boolean containsAny(AllowableActions actions, AllowableAction ... action) {
        for (AllowableAction a : action) {
            if (!actions.contains(a)) continue;
            return true;
        }
        return false;
    }

    public Predicate visibleDomainsPredicate(QWebCmsDomain domain) {
        BooleanExpression predicate = null;
        if (!this.multiDomainConfiguration.isDisabled()) {
            WebCmsDomain currentDomain = this.getSelectedDomain();
            if (!WebCmsDomain.isNoDomain(currentDomain)) {
                predicate = domain.eq(currentDomain);
            }
            if (this.multiDomainConfiguration.isNoDomainAllowed()) {
                predicate = ExpressionUtils.or((Predicate)predicate, (Predicate)domain.isNull());
            }
        }
        return predicate;
    }

    public Predicate applyVisibleDomainsPredicate(Predicate predicate, QWebCmsDomain domain) {
        return ExpressionUtils.and((Predicate)predicate, (Predicate)this.visibleDomainsPredicate(domain));
    }

    public WebCmsMultiDomainAdminUiService(EntityRegistry entityRegistry, WebCmsMultiDomainConfiguration multiDomainConfiguration, WebCmsDomainRepository domainRepository) {
        this.entityRegistry = entityRegistry;
        this.multiDomainConfiguration = multiDomainConfiguration;
        this.domainRepository = domainRepository;
    }
}

