/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain;

import com.foreach.across.modules.webcms.domain.domain.CloseableWebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainCache;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContextHolder;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
class WebCmsMultiDomainServiceImpl
implements WebCmsMultiDomainService {
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
    private final WebCmsDomainCache domainCache;

    @Override
    public WebCmsDomain getDomain(String objectId) {
        return this.domainCache.getDomain(objectId);
    }

    @Override
    public WebCmsDomain getDomainByKey(String domainKey) {
        return this.domainCache.getDomainByKey(domainKey);
    }

    @Override
    public <U> U getMetadataForDomain(WebCmsDomain domain, Class<U> metadataType) {
        return metadataType.cast(this.domainCache.getMetadataForDomain(domain));
    }

    @Override
    public WebCmsDomain getCurrentDomain() {
        WebCmsDomainContext domainContext = WebCmsDomainContextHolder.getWebCmsDomainContext();
        return domainContext != null ? domainContext.getDomain() : null;
    }

    @Override
    public <U> U getCurrentDomainMetadata(Class<U> metadataType) {
        WebCmsDomainContext domainContext = WebCmsDomainContextHolder.getWebCmsDomainContext();
        return domainContext != null ? (U)domainContext.getMetadata(metadataType) : null;
    }

    @Override
    public WebCmsDomain getCurrentDomainForEntity(Object entity) {
        return this.isDomainBound(entity) ? this.getCurrentDomain() : WebCmsDomain.NONE;
    }

    @Override
    public WebCmsDomain getCurrentDomainForType(Class<?> entityType) {
        return this.isDomainBound(entityType) ? this.getCurrentDomain() : WebCmsDomain.NONE;
    }

    @Override
    public boolean isDomainBound(Object entity) {
        return entity != null && this.isDomainBound(ClassUtils.getUserClass((Object)entity));
    }

    @Override
    public boolean isDomainBound(Class<?> entityType) {
        return entityType != null && this.multiDomainConfiguration.isDomainBound(entityType);
    }

    @Override
    public boolean isNoDomainAllowed(Object entity) {
        return entity != null && this.isNoDomainAllowed(ClassUtils.getUserClass((Object)entity));
    }

    @Override
    public boolean isNoDomainAllowed(Class<?> entityType) {
        return entityType != null && this.multiDomainConfiguration.isNoDomainAllowed(entityType);
    }

    @Override
    public CloseableWebCmsDomainContext attachDomainContext(WebCmsDomain domain) {
        return new CloseableWebCmsDomainContext(domain != null ? new WebCmsDomainContext(domain, this.getMetadataForDomain(domain, Object.class)) : WebCmsDomainContext.noDomain(this.getMetadataForDomain(null, Object.class)));
    }

    @Override
    public boolean isCurrentDomain(WebCmsDomain domain) {
        WebCmsDomain currentDomain = this.getCurrentDomain();
        if (WebCmsDomain.isNoDomain(currentDomain)) {
            return domain == WebCmsDomain.NONE;
        }
        return currentDomain.equals(domain);
    }

    public WebCmsMultiDomainServiceImpl(WebCmsMultiDomainConfiguration multiDomainConfiguration, WebCmsDomainCache domainCache) {
        this.multiDomainConfiguration = multiDomainConfiguration;
        this.domainCache = domainCache;
    }
}

