/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.config;

import com.foreach.across.condition.ConditionalOnConfigurableServletContext;
import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.support.ReadableAttributes;
import com.foreach.across.core.support.WritableAttributes;
import com.foreach.across.modules.adminweb.config.support.AdminWebConfigurerAdapter;
import com.foreach.across.modules.entity.EntityAttributes;
import com.foreach.across.modules.entity.actions.EntityConfigurationAllowableActionsBuilder;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.query.EQValue;
import com.foreach.across.modules.entity.query.EntityQuery;
import com.foreach.across.modules.entity.query.EntityQueryCondition;
import com.foreach.across.modules.entity.query.EntityQueryConditionTranslator;
import com.foreach.across.modules.entity.query.EntityQueryExpression;
import com.foreach.across.modules.entity.query.EntityQueryOps;
import com.foreach.across.modules.entity.registry.DefaultEntityModel;
import com.foreach.across.modules.entity.registry.EntityAssociation;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityFactory;
import com.foreach.across.modules.entity.registry.EntityModel;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.registry.EntityViewRegistry;
import com.foreach.across.modules.entity.registry.MutableEntityAssociation;
import com.foreach.across.modules.entity.registry.MutableEntityConfiguration;
import com.foreach.across.modules.entity.registry.PersistentEntityFactory;
import com.foreach.across.modules.entity.registry.properties.EntityPropertyDescriptor;
import com.foreach.across.modules.entity.registry.properties.MutableEntityPropertyDescriptor;
import com.foreach.across.modules.entity.registry.properties.MutableEntityPropertyRegistry;
import com.foreach.across.modules.entity.views.DispatchingEntityViewFactory;
import com.foreach.across.modules.entity.views.EntityViewFactory;
import com.foreach.across.modules.entity.views.processors.DefaultEntityFetchingViewProcessor;
import com.foreach.across.modules.entity.views.processors.EntityQueryFilterProcessor;
import com.foreach.across.modules.entity.views.processors.support.EntityViewProcessorRegistry;
import com.foreach.across.modules.web.mvc.InterceptorRegistry;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.domain.EntityQueryWebCmsDomainFunctions;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.foreach.across.modules.webcms.domain.domain.support.CurrentDomainAwareAllowableActionsBuilder;
import com.foreach.across.modules.webcms.domain.domain.support.CurrentDomainAwareEntityFactory;
import com.foreach.across.modules.webcms.domain.domain.web.AbstractWebCmsDomainContextFilter;
import com.foreach.across.modules.webcms.domain.domain.web.CookieWebCmsDomainContextResolver;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainContextHandlerInterceptor;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainContextResolver;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainLocaleContextResolver;
import java.util.Collections;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleContextResolver;

@Configuration
class WebCmsDomainConfiguration {
    WebCmsDomainConfiguration() {
    }

    @Bean
    @Exposed
    @ConditionalOnMissingBean(value={WebCmsMultiDomainConfiguration.class})
    public WebCmsMultiDomainConfiguration multiDomainConfiguration() {
        return WebCmsMultiDomainConfiguration.disabled().build();
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnConfigurableServletContext
    @ConditionalOnExpression(value="@multiDomainConfiguration.domainContextFilterClass != null")
    public FilterRegistrationBean siteConfigurationFilter(BeanFactory beanFactory, WebCmsMultiDomainConfiguration multiDomainConfiguration) {
        Class<? extends AbstractWebCmsDomainContextFilter> filterClass = multiDomainConfiguration.getDomainContextFilterClass();
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("domainContextFilter");
        registration.setFilter((Filter)beanFactory.getBean(filterClass));
        registration.setAsyncSupported(true);
        registration.setMatchAfter(false);
        registration.setUrlPatterns(Collections.singletonList("/*"));
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.ASYNC});
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean(value={"localeResolver"})
    @Primary
    @Exposed
    @ConditionalOnExpression(value="not @multiDomainConfiguration.disabled")
    @ConditionalOnMissingBean(name={"localeResolver"})
    public LocaleContextResolver localeResolver(WebCmsDomainLocaleContextResolver domainLocaleContextResolver) {
        return domainLocaleContextResolver;
    }

    @ConditionalOnAdminUI
    @Configuration
    static class AdminUiConfiguration
    extends AdminWebConfigurerAdapter
    implements EntityConfigurer {
        private static final Logger LOG = LoggerFactory.getLogger(AdminUiConfiguration.class);
        private static final String PROPERTY = "domain";
        private final EntityRegistry entityRegistry;
        private final AutowireCapableBeanFactory beanFactory;
        private final WebCmsMultiDomainService multiDomainService;
        private final WebCmsMultiDomainConfiguration multiDomainConfiguration;

        public void addInterceptors(InterceptorRegistry interceptorRegistry) {
            if (!this.multiDomainConfiguration.isDisabled()) {
                WebCmsDomainContextHandlerInterceptor interceptor = new WebCmsDomainContextHandlerInterceptor((WebCmsDomainContextResolver)this.beanFactory.getBean("adminWebCookieDomainResolver", WebCmsDomainContextResolver.class));
                interceptorRegistry.addFirst((HandlerInterceptor)interceptor);
            }
        }

        @Bean
        @Lazy
        public CookieWebCmsDomainContextResolver adminWebCookieDomainResolver(WebCmsDomainService domainService, ApplicationEventPublisher applicationEventPublisher) {
            return new CookieWebCmsDomainContextResolver(domainService, applicationEventPublisher);
        }

        public void configure(EntitiesConfigurationBuilder entities) {
            entities.withType(WebCmsDomain.class).attribute("webCmsModule.multiDomain.domainProperty", (Object)"id").properties(props -> props.property("attributes").hidden(true).and().property("id").attribute(EntityQueryConditionTranslator.class, (Object)EntityQueryWebCmsDomainFunctions.conditionTranslator()));
            entities.assignableTo(WebCmsDomainBound.class).properties(props -> props.property(PROPERTY).attribute(EntityQueryConditionTranslator.class, (Object)EntityQueryWebCmsDomainFunctions.conditionTranslator()).order(Integer.MIN_VALUE));
            entities.withType(WebCmsDomain.class).hide();
            if (this.multiDomainConfiguration.isDisabled()) {
                this.hideDomainRelatedConfiguration(entities);
            } else if (this.multiDomainConfiguration.isDomainSelectablePerEntity()) {
                this.configureDomainManagementPerEntity(entities);
            } else {
                this.configureDomainManagementPerDomain(entities);
            }
        }

        private void configureDomainManagementPerEntity(EntitiesConfigurationBuilder entities) {
            EntityQueryCondition domainCondition = new EntityQueryCondition("id", EntityQueryOps.IN, new Object[]{new EQValue("accessibleDomains()")});
            EntityQueryCondition boundObjectCondition = new EntityQueryCondition(PROPERTY, EntityQueryOps.IN, new Object[]{new EQValue("accessibleDomains()")});
            entities.all().postProcessor(cfg -> {
                if (this.shouldAutoConfigure((WritableAttributes)cfg, "webCmsModule.multiDomain.configuration.finished")) {
                    Class entityType = cfg.getEntityType();
                    MutableEntityPropertyRegistry propertyRegistry = cfg.getPropertyRegistry();
                    if (WebCmsDomain.class.isAssignableFrom(entityType)) {
                        this.adjustOptionsQuery((WritableAttributes)cfg, this.translateDomainCondition((EntityConfiguration)cfg, domainCondition), true);
                        this.adjustListView(cfg, this.translateDomainCondition((EntityConfiguration)cfg, domainCondition));
                    } else if (WebCmsDomainBound.class.isAssignableFrom(entityType)) {
                        if (!this.multiDomainConfiguration.isDomainBound(entityType)) {
                            MutableEntityPropertyDescriptor prop = propertyRegistry.getProperty(PROPERTY);
                            prop.setReadable(false);
                            prop.setWritable(false);
                            prop.setHidden(true);
                        } else {
                            this.adjustOptionsQuery((WritableAttributes)cfg, this.translateDomainCondition((EntityConfiguration)cfg, boundObjectCondition), true);
                            this.adjustListView(cfg, this.translateDomainCondition((EntityConfiguration)cfg, boundObjectCondition));
                        }
                    }
                    propertyRegistry.getProperties().stream().filter(p -> p.getPropertyType() != null).filter(p -> WebCmsDomain.class.isAssignableFrom(p.getPropertyType())).map(p -> propertyRegistry.getProperty(p.getName())).forEach(p -> this.adjustOptionsQuery((WritableAttributes)p, this.translateDomainCondition((EntityPropertyDescriptor)p, domainCondition), false));
                    propertyRegistry.getProperties().stream().filter(p -> p.getPropertyType() != null).filter(p -> WebCmsDomainBound.class.isAssignableFrom(p.getPropertyType()) && this.multiDomainConfiguration.isDomainBound(p.getPropertyType())).map(p -> propertyRegistry.getProperty(p.getName())).forEach(p -> this.adjustOptionsQuery((WritableAttributes)p, this.translateDomainCondition((EntityPropertyDescriptor)p, boundObjectCondition), false));
                    cfg.getAssociations().stream().map(MutableEntityAssociation.class::cast).filter(a -> this.filterType((EntityAssociation)a, WebCmsDomain.class, false) && a.hasView("listView")).forEach(a -> this.adjustListView(a, this.translateDomainCondition((EntityAssociation)a, domainCondition)));
                    cfg.getAssociations().stream().map(MutableEntityAssociation.class::cast).filter(a -> this.filterType((EntityAssociation)a, WebCmsDomainBound.class, true) && a.hasView("listView")).forEach(a -> this.adjustListView(a, this.translateDomainCondition((EntityAssociation)a, boundObjectCondition)));
                }
            });
        }

        private void configureDomainManagementPerDomain(EntitiesConfigurationBuilder entities) {
            this.hideDomainRelatedConfiguration(entities);
            EntityQueryCondition domainCondition = new EntityQueryCondition("id", EntityQueryOps.IN, new Object[]{new EQValue("accessibleDomains()")});
            EntityQueryCondition visibleDomainsCondition = new EntityQueryCondition(PROPERTY, EntityQueryOps.IN, new Object[]{new EQValue("visibleDomains()")});
            EntityQueryCondition selectedDomainCondition = new EntityQueryCondition(PROPERTY, EntityQueryOps.EQ, new Object[]{new EQValue("selectedDomain()")});
            entities.all().postProcessor(cfg -> {
                if (this.shouldAutoConfigure((WritableAttributes)cfg, "webCmsModule.multiDomain.configuration.finished")) {
                    Class entityType = cfg.getEntityType();
                    MutableEntityPropertyRegistry propertyRegistry = cfg.getPropertyRegistry();
                    if (WebCmsDomain.class.isAssignableFrom(entityType)) {
                        this.adjustOptionsQuery((WritableAttributes)cfg, this.translateDomainCondition((EntityConfiguration)cfg, domainCondition), true);
                    } else if (this.multiDomainConfiguration.isDomainBound(entityType)) {
                        this.adjustOptionsQuery((WritableAttributes)cfg, this.translateDomainCondition((EntityConfiguration)cfg, visibleDomainsCondition), true);
                        this.adjustListView(cfg, this.translateDomainCondition((EntityConfiguration)cfg, selectedDomainCondition));
                        this.registerDomainAwareEntityFactory((MutableEntityConfiguration)cfg);
                        this.registerEntityQueryConditionTranslator((MutableEntityConfiguration<Object>)cfg);
                    }
                    if (!WebCmsDomain.class.isAssignableFrom(entityType) && this.shouldAutoConfigure((WritableAttributes)cfg, "webCmsModule.multiDomain.configuration.allowableActionsAdjusted")) {
                        cfg.setAllowableActionsBuilder(this.createDomainBasedAllowableActionsBuilder(cfg.getAllowableActionsBuilder()));
                    }
                    propertyRegistry.getProperties().stream().filter(p -> p.getPropertyType() != null).filter(p -> WebCmsDomain.class.isAssignableFrom(p.getPropertyType())).map(p -> propertyRegistry.getProperty(p.getName())).forEach(p -> this.adjustOptionsQuery((WritableAttributes)p, this.translateDomainCondition((EntityPropertyDescriptor)p, domainCondition), false));
                    propertyRegistry.getProperties().stream().filter(p -> p.getPropertyType() != null).filter(p -> WebCmsDomainBound.class.isAssignableFrom(p.getPropertyType()) && this.multiDomainConfiguration.isDomainBound(p.getPropertyType())).map(p -> propertyRegistry.getProperty(p.getName())).forEach(p -> this.adjustOptionsQuery((WritableAttributes)p, this.translateDomainCondition((EntityPropertyDescriptor)p, visibleDomainsCondition), false));
                    cfg.getAssociations().stream().map(MutableEntityAssociation.class::cast).filter(a -> this.filterType((EntityAssociation)a, WebCmsDomain.class, false) && a.hasView("listView")).forEach(a -> this.adjustListView(a, this.translateDomainCondition((EntityAssociation)a, domainCondition)));
                    cfg.getAssociations().stream().map(MutableEntityAssociation.class::cast).filter(a -> this.filterType((EntityAssociation)a, WebCmsDomainBound.class, true) && a.hasView("listView")).forEach(a -> this.adjustListView(a, this.translateDomainCondition((EntityAssociation)a, selectedDomainCondition)));
                }
            });
        }

        private void registerEntityQueryConditionTranslator(MutableEntityConfiguration<Object> entityConfiguration) {
            if (entityConfiguration.hasAttribute("webCmsModule.multiDomain.domainProperty")) {
                String domainProperty = (String)entityConfiguration.getAttribute("webCmsModule.multiDomain.domainProperty", String.class);
                MutableEntityPropertyDescriptor propertyDescriptor = entityConfiguration.getPropertyRegistry().getProperty(domainProperty);
                if (!propertyDescriptor.hasAttribute(EntityQueryConditionTranslator.class)) {
                    propertyDescriptor.setAttribute(EntityQueryConditionTranslator.class, (Object)EntityQueryWebCmsDomainFunctions.conditionTranslator());
                }
            }
        }

        private void registerDomainAwareEntityFactory(MutableEntityConfiguration entityConfiguration) {
            PersistentEntity persistentEntity;
            if (WebCmsDomainBound.class.isAssignableFrom(entityConfiguration.getEntityType()) && this.shouldAutoConfigure((WritableAttributes)entityConfiguration, "webCmsModule.multiDomain.configuration.entityModelAdjusted") && (persistentEntity = (PersistentEntity)entityConfiguration.getAttribute(PersistentEntity.class)) != null) {
                PersistentEntityFactory pef = new PersistentEntityFactory(persistentEntity);
                EntityModel entityModel = entityConfiguration.getEntityModel();
                if (entityModel instanceof DefaultEntityModel) {
                    ((DefaultEntityModel)entityModel).setEntityFactory((EntityFactory)new CurrentDomainAwareEntityFactory(this.multiDomainService, (EntityFactory<WebCmsDomainBound>)pef));
                }
            }
        }

        private EntityConfigurationAllowableActionsBuilder createDomainBasedAllowableActionsBuilder(EntityConfigurationAllowableActionsBuilder original) {
            return new CurrentDomainAwareAllowableActionsBuilder(this.multiDomainService, original);
        }

        private boolean filterType(EntityAssociation association, Class<?> expectedType, boolean requireDomainBound) {
            return association.getTargetEntityConfiguration() != null && association.getTargetEntityConfiguration().getEntityType() != null && association.getTargetProperty() != null && expectedType.isAssignableFrom(association.getTargetEntityConfiguration().getEntityType()) && (!requireDomainBound || this.multiDomainConfiguration.isDomainBound(association.getTargetEntityConfiguration().getEntityType()));
        }

        private void adjustOptionsQuery(WritableAttributes owner, EntityQueryCondition condition, boolean always) {
            if (condition != null && this.shouldAutoConfigure(owner, "webCmsModule.multiDomain.configuration.optionsQueryAdjusted")) {
                Object currentQuery = owner.getAttribute(EntityAttributes.OPTIONS_ENTITY_QUERY);
                String newQuery = null;
                if (currentQuery != null) {
                    if (currentQuery instanceof String) {
                        newQuery = "(" + currentQuery + ") and (" + condition + ")";
                    } else if (currentQuery instanceof EntityQuery) {
                        newQuery = EntityQuery.and((EntityQueryExpression[])new EntityQueryExpression[]{(EntityQuery)currentQuery, new EntityQueryCondition(condition.getProperty(), condition.getOperand(), condition.getArguments())});
                    }
                } else if (always) {
                    newQuery = condition.toString();
                }
                if (newQuery != null) {
                    owner.setAttribute(EntityAttributes.OPTIONS_ENTITY_QUERY, (Object)newQuery);
                }
            }
        }

        private <V extends EntityViewRegistry & WritableAttributes> void adjustListView(V registry, EntityQueryCondition condition) {
            EntityViewFactory viewFactory;
            if (condition != null && this.shouldAutoConfigure(registry, "webCmsModule.multiDomain.configuration.listViewAdjusted") && (viewFactory = registry.getViewFactory("listView")) != null && viewFactory instanceof DispatchingEntityViewFactory) {
                EntityViewProcessorRegistry processors = ((DispatchingEntityViewFactory)viewFactory).getProcessorRegistry();
                processors.getProcessor(EntityQueryFilterProcessor.class.getName(), EntityQueryFilterProcessor.class).ifPresent(pp -> pp.setFilterConfiguration(pp.getFilterConfiguration().toBuilder().basePredicate(condition.toString()).build()));
                processors.getProcessor(DefaultEntityFetchingViewProcessor.class.getName(), DefaultEntityFetchingViewProcessor.class).ifPresent(pp -> pp.setBaseEqlPredicate(condition.toString()));
            }
        }

        private EntityQueryCondition translateDomainCondition(EntityAssociation entityAssociation, EntityQueryCondition condition) {
            return this.translateDomainCondition(entityAssociation.getTargetEntityConfiguration(), condition);
        }

        private EntityQueryCondition translateDomainCondition(EntityPropertyDescriptor propertyDescriptor, EntityQueryCondition condition) {
            return this.translateDomainCondition(this.entityRegistry.getEntityConfiguration(propertyDescriptor.getPropertyType()), condition);
        }

        private EntityQueryCondition translateDomainCondition(EntityConfiguration entityConfiguration, EntityQueryCondition condition) {
            return this.translateDomainCondition(entityConfiguration.getEntityType(), (ReadableAttributes)entityConfiguration, condition);
        }

        private EntityQueryCondition translateDomainCondition(Class<?> entityType, ReadableAttributes owner, EntityQueryCondition condition) {
            String domainProperty = (String)owner.getAttribute("webCmsModule.multiDomain.domainProperty", String.class);
            if (WebCmsDomainBound.class.isAssignableFrom(entityType) || domainProperty != null) {
                if (domainProperty != null) {
                    return new EntityQueryCondition(domainProperty, condition.getOperand(), condition.getArguments());
                }
                return condition;
            }
            return null;
        }

        private boolean shouldAutoConfigure(WritableAttributes attributes, String attributeName) {
            if (!Boolean.TRUE.equals(attributes.getAttribute(attributeName))) {
                attributes.setAttribute(attributeName, (Object)true);
                return true;
            }
            return false;
        }

        private void hideDomainRelatedConfiguration(EntitiesConfigurationBuilder entities) {
            entities.assignableTo(WebCmsDomainBound.class).properties(props -> props.property(PROPERTY).readable(false).writable(true).hidden(true));
        }

        public AdminUiConfiguration(EntityRegistry entityRegistry, AutowireCapableBeanFactory beanFactory, WebCmsMultiDomainService multiDomainService, WebCmsMultiDomainConfiguration multiDomainConfiguration) {
            this.entityRegistry = entityRegistry;
            this.beanFactory = beanFactory;
            this.multiDomainService = multiDomainService;
            this.multiDomainConfiguration = multiDomainConfiguration;
        }
    }
}

