/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.config;

import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainAware;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.web.AbstractWebCmsDomainContextFilter;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsSiteConfigurationFilter;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsSiteConfigurationImpl;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class WebCmsMultiDomainConfiguration {
    private final Set<Class<?>> domainBoundTypes;
    private final Set<Class<?>> domainIgnoredTypes;
    private final Set<Class<?>> noDomainAllowedTypes;
    private String defaultDomainKey;
    private boolean noDomainAllowed;
    private boolean disabled;
    private boolean domainSelectablePerEntity;
    private Class<? extends WebCmsDomainAware> metadataClass;
    private String noDomainMetadataBeanName;
    private Class<? extends AbstractWebCmsDomainContextFilter> domainContextFilterClass;

    public static WebCmsMultiDomainConfigurationBuilder disabled() {
        return WebCmsMultiDomainConfiguration.builder();
    }

    public static WebCmsMultiDomainConfigurationBuilder managementPerDomain() {
        return WebCmsMultiDomainConfiguration.builder().disabled(false).domainSelectablePerEntity(false).domainBoundTypes(WebCmsDomainBound.class, WebCmsUrl.class, WebCmsMenuItem.class).domainIgnoredTypes(WebCmsTypeSpecifier.class).noDomainAllowedTypes(WebCmsComponent.class);
    }

    public static WebCmsMultiDomainConfigurationBuilder managementPerEntity() {
        return WebCmsMultiDomainConfiguration.builder().disabled(false).domainSelectablePerEntity(true).domainBoundTypes(WebCmsDomainBound.class, WebCmsUrl.class, WebCmsMenuItem.class).domainIgnoredTypes(WebCmsTypeSpecifier.class).noDomainAllowedTypes(WebCmsComponent.class);
    }

    public Class<? extends AbstractWebCmsDomainContextFilter> getDomainContextFilterClass() {
        return this.isDisabled() ? null : this.domainContextFilterClass;
    }

    public boolean isDomainBound(@NonNull Class<?> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (this.isDisabled()) {
            return false;
        }
        for (Class<?> ignored : this.domainIgnoredTypes) {
            if (!ignored.equals(entityType)) continue;
            return false;
        }
        for (Class<?> bound : this.domainBoundTypes) {
            if (!bound.equals(entityType)) continue;
            return true;
        }
        for (Class<?> ignored : this.domainIgnoredTypes) {
            if (!ignored.isAssignableFrom(entityType)) continue;
            return false;
        }
        for (Class<?> bound : this.domainBoundTypes) {
            if (!bound.isAssignableFrom(entityType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNoDomainAllowed(@NonNull Class<?> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (this.isDisabled() || !this.isDomainBound(entityType)) {
            return true;
        }
        if (this.isNoDomainAllowed()) {
            for (Class<?> noDomainAllowed : this.noDomainAllowedTypes) {
                if (!noDomainAllowed.isAssignableFrom(entityType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean $default$noDomainAllowed() {
        return true;
    }

    private static boolean $default$disabled() {
        return true;
    }

    private static boolean $default$domainSelectablePerEntity() {
        return false;
    }

    private static Class<? extends WebCmsDomainAware> $default$metadataClass() {
        return WebCmsSiteConfigurationImpl.class;
    }

    private static Class<? extends AbstractWebCmsDomainContextFilter> $default$domainContextFilterClass() {
        return WebCmsSiteConfigurationFilter.class;
    }

    public static WebCmsMultiDomainConfigurationBuilder builder() {
        return new WebCmsMultiDomainConfigurationBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebCmsMultiDomainConfiguration)) {
            return false;
        }
        WebCmsMultiDomainConfiguration other = (WebCmsMultiDomainConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNoDomainAllowed() != other.isNoDomainAllowed()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isDomainSelectablePerEntity() != other.isDomainSelectablePerEntity()) {
            return false;
        }
        Set<Class<?>> this$domainBoundTypes = this.getDomainBoundTypes();
        Set<Class<?>> other$domainBoundTypes = other.getDomainBoundTypes();
        if (this$domainBoundTypes == null ? other$domainBoundTypes != null : !((Object)this$domainBoundTypes).equals(other$domainBoundTypes)) {
            return false;
        }
        Set<Class<?>> this$domainIgnoredTypes = this.getDomainIgnoredTypes();
        Set<Class<?>> other$domainIgnoredTypes = other.getDomainIgnoredTypes();
        if (this$domainIgnoredTypes == null ? other$domainIgnoredTypes != null : !((Object)this$domainIgnoredTypes).equals(other$domainIgnoredTypes)) {
            return false;
        }
        Set<Class<?>> this$noDomainAllowedTypes = this.getNoDomainAllowedTypes();
        Set<Class<?>> other$noDomainAllowedTypes = other.getNoDomainAllowedTypes();
        if (this$noDomainAllowedTypes == null ? other$noDomainAllowedTypes != null : !((Object)this$noDomainAllowedTypes).equals(other$noDomainAllowedTypes)) {
            return false;
        }
        String this$defaultDomainKey = this.getDefaultDomainKey();
        String other$defaultDomainKey = other.getDefaultDomainKey();
        if (this$defaultDomainKey == null ? other$defaultDomainKey != null : !this$defaultDomainKey.equals(other$defaultDomainKey)) {
            return false;
        }
        Class<? extends WebCmsDomainAware> this$metadataClass = this.getMetadataClass();
        Class<? extends WebCmsDomainAware> other$metadataClass = other.getMetadataClass();
        if (this$metadataClass == null ? other$metadataClass != null : !this$metadataClass.equals(other$metadataClass)) {
            return false;
        }
        String this$noDomainMetadataBeanName = this.getNoDomainMetadataBeanName();
        String other$noDomainMetadataBeanName = other.getNoDomainMetadataBeanName();
        if (this$noDomainMetadataBeanName == null ? other$noDomainMetadataBeanName != null : !this$noDomainMetadataBeanName.equals(other$noDomainMetadataBeanName)) {
            return false;
        }
        Class<? extends AbstractWebCmsDomainContextFilter> this$domainContextFilterClass = this.getDomainContextFilterClass();
        Class<? extends AbstractWebCmsDomainContextFilter> other$domainContextFilterClass = other.getDomainContextFilterClass();
        return !(this$domainContextFilterClass == null ? other$domainContextFilterClass != null : !this$domainContextFilterClass.equals(other$domainContextFilterClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebCmsMultiDomainConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoDomainAllowed() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isDomainSelectablePerEntity() ? 79 : 97);
        Set<Class<?>> $domainBoundTypes = this.getDomainBoundTypes();
        result = result * 59 + ($domainBoundTypes == null ? 43 : ((Object)$domainBoundTypes).hashCode());
        Set<Class<?>> $domainIgnoredTypes = this.getDomainIgnoredTypes();
        result = result * 59 + ($domainIgnoredTypes == null ? 43 : ((Object)$domainIgnoredTypes).hashCode());
        Set<Class<?>> $noDomainAllowedTypes = this.getNoDomainAllowedTypes();
        result = result * 59 + ($noDomainAllowedTypes == null ? 43 : ((Object)$noDomainAllowedTypes).hashCode());
        String $defaultDomainKey = this.getDefaultDomainKey();
        result = result * 59 + ($defaultDomainKey == null ? 43 : $defaultDomainKey.hashCode());
        Class<? extends WebCmsDomainAware> $metadataClass = this.getMetadataClass();
        result = result * 59 + ($metadataClass == null ? 43 : $metadataClass.hashCode());
        String $noDomainMetadataBeanName = this.getNoDomainMetadataBeanName();
        result = result * 59 + ($noDomainMetadataBeanName == null ? 43 : $noDomainMetadataBeanName.hashCode());
        Class<? extends AbstractWebCmsDomainContextFilter> $domainContextFilterClass = this.getDomainContextFilterClass();
        result = result * 59 + ($domainContextFilterClass == null ? 43 : $domainContextFilterClass.hashCode());
        return result;
    }

    public String getDefaultDomainKey() {
        return this.defaultDomainKey;
    }

    public boolean isNoDomainAllowed() {
        return this.noDomainAllowed;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDomainSelectablePerEntity() {
        return this.domainSelectablePerEntity;
    }

    public Class<? extends WebCmsDomainAware> getMetadataClass() {
        return this.metadataClass;
    }

    public String getNoDomainMetadataBeanName() {
        return this.noDomainMetadataBeanName;
    }

    private WebCmsMultiDomainConfiguration(Set<Class<?>> domainBoundTypes, Set<Class<?>> domainIgnoredTypes, Set<Class<?>> noDomainAllowedTypes, String defaultDomainKey, boolean noDomainAllowed, boolean disabled, boolean domainSelectablePerEntity, Class<? extends WebCmsDomainAware> metadataClass, String noDomainMetadataBeanName, Class<? extends AbstractWebCmsDomainContextFilter> domainContextFilterClass) {
        this.domainBoundTypes = domainBoundTypes;
        this.domainIgnoredTypes = domainIgnoredTypes;
        this.noDomainAllowedTypes = noDomainAllowedTypes;
        this.defaultDomainKey = defaultDomainKey;
        this.noDomainAllowed = noDomainAllowed;
        this.disabled = disabled;
        this.domainSelectablePerEntity = domainSelectablePerEntity;
        this.metadataClass = metadataClass;
        this.noDomainMetadataBeanName = noDomainMetadataBeanName;
        this.domainContextFilterClass = domainContextFilterClass;
    }

    public Set<Class<?>> getDomainBoundTypes() {
        return this.domainBoundTypes;
    }

    public Set<Class<?>> getDomainIgnoredTypes() {
        return this.domainIgnoredTypes;
    }

    public Set<Class<?>> getNoDomainAllowedTypes() {
        return this.noDomainAllowedTypes;
    }

    public static class WebCmsMultiDomainConfigurationBuilder {
        private Set<Class<?>> domainBoundTypes = new HashSet();
        private Set<Class<?>> domainIgnoredTypes = new HashSet();
        private Set<Class<?>> noDomainAllowedTypes = new HashSet();
        private String defaultDomainKey;
        private boolean noDomainAllowed$set;
        private boolean noDomainAllowed$value;
        private boolean disabled$set;
        private boolean disabled$value;
        private boolean domainSelectablePerEntity$set;
        private boolean domainSelectablePerEntity$value;
        private boolean metadataClass$set;
        private Class<? extends WebCmsDomainAware> metadataClass$value;
        private String noDomainMetadataBeanName;
        private boolean domainContextFilterClass$set;
        private Class<? extends AbstractWebCmsDomainContextFilter> domainContextFilterClass$value;

        public WebCmsMultiDomainConfigurationBuilder domainBoundTypes(Class<?> ... entityTypes) {
            return this.domainBoundTypes(Arrays.asList(entityTypes));
        }

        public WebCmsMultiDomainConfigurationBuilder domainBoundTypes(Collection<Class<?>> entityTypes) {
            this.domainBoundTypes.addAll(entityTypes);
            this.domainIgnoredTypes.removeAll(entityTypes);
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder clearDomainBoundTypes() {
            this.domainBoundTypes.clear();
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder domainIgnoredTypes(Class<?> ... entityTypes) {
            return this.domainIgnoredTypes(Arrays.asList(entityTypes));
        }

        public WebCmsMultiDomainConfigurationBuilder domainIgnoredTypes(Collection<Class<?>> entityTypes) {
            this.domainIgnoredTypes.addAll(entityTypes);
            this.domainBoundTypes.removeAll(entityTypes);
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder clearDomainIgnoredTypes() {
            this.domainIgnoredTypes.clear();
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder noDomainAllowedTypes(Class<?> ... entityTypes) {
            return this.noDomainAllowedTypes(Arrays.asList(entityTypes));
        }

        public WebCmsMultiDomainConfigurationBuilder noDomainAllowedTypes(Collection<Class<?>> entityTypes) {
            this.noDomainAllowedTypes.addAll(entityTypes);
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder clearNoDomainAllowedTypes() {
            this.noDomainAllowedTypes.clear();
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder defaultDomainKey(String defaultDomainKey) {
            this.defaultDomainKey = defaultDomainKey;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder noDomainAllowed(boolean noDomainAllowed) {
            this.noDomainAllowed$value = noDomainAllowed;
            this.noDomainAllowed$set = true;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder domainSelectablePerEntity(boolean domainSelectablePerEntity) {
            this.domainSelectablePerEntity$value = domainSelectablePerEntity;
            this.domainSelectablePerEntity$set = true;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder metadataClass(Class<? extends WebCmsDomainAware> metadataClass) {
            this.metadataClass$value = metadataClass;
            this.metadataClass$set = true;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder noDomainMetadataBeanName(String noDomainMetadataBeanName) {
            this.noDomainMetadataBeanName = noDomainMetadataBeanName;
            return this;
        }

        public WebCmsMultiDomainConfigurationBuilder domainContextFilterClass(Class<? extends AbstractWebCmsDomainContextFilter> domainContextFilterClass) {
            this.domainContextFilterClass$value = domainContextFilterClass;
            this.domainContextFilterClass$set = true;
            return this;
        }

        public WebCmsMultiDomainConfiguration build() {
            boolean noDomainAllowed$value = this.noDomainAllowed$value;
            if (!this.noDomainAllowed$set) {
                noDomainAllowed$value = WebCmsMultiDomainConfiguration.$default$noDomainAllowed();
            }
            boolean disabled$value = this.disabled$value;
            if (!this.disabled$set) {
                disabled$value = WebCmsMultiDomainConfiguration.$default$disabled();
            }
            boolean domainSelectablePerEntity$value = this.domainSelectablePerEntity$value;
            if (!this.domainSelectablePerEntity$set) {
                domainSelectablePerEntity$value = WebCmsMultiDomainConfiguration.$default$domainSelectablePerEntity();
            }
            Class metadataClass$value = this.metadataClass$value;
            if (!this.metadataClass$set) {
                metadataClass$value = WebCmsMultiDomainConfiguration.$default$metadataClass();
            }
            Class domainContextFilterClass$value = this.domainContextFilterClass$value;
            if (!this.domainContextFilterClass$set) {
                domainContextFilterClass$value = WebCmsMultiDomainConfiguration.$default$domainContextFilterClass();
            }
            return new WebCmsMultiDomainConfiguration(this.domainBoundTypes, this.domainIgnoredTypes, this.noDomainAllowedTypes, this.defaultDomainKey, noDomainAllowed$value, disabled$value, domainSelectablePerEntity$value, metadataClass$value, this.noDomainMetadataBeanName, domainContextFilterClass$value);
        }

        public String toString() {
            return "WebCmsMultiDomainConfiguration.WebCmsMultiDomainConfigurationBuilder(domainBoundTypes=" + this.domainBoundTypes + ", domainIgnoredTypes=" + this.domainIgnoredTypes + ", noDomainAllowedTypes=" + this.noDomainAllowedTypes + ", defaultDomainKey=" + this.defaultDomainKey + ", noDomainAllowed$value=" + this.noDomainAllowed$value + ", disabled$value=" + this.disabled$value + ", domainSelectablePerEntity$value=" + this.domainSelectablePerEntity$value + ", metadataClass$value=" + this.metadataClass$value + ", noDomainMetadataBeanName=" + this.noDomainMetadataBeanName + ", domainContextFilterClass$value=" + this.domainContextFilterClass$value + ")";
        }
    }
}

