/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.support;

import com.foreach.across.modules.entity.actions.EntityConfigurationAllowableActionsBuilder;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.spring.security.actions.AllowableAction;
import com.foreach.across.modules.spring.security.actions.AllowableActions;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import java.util.Collections;
import java.util.Iterator;
import org.springframework.beans.BeanWrapperImpl;

public class CurrentDomainAwareAllowableActionsBuilder
implements EntityConfigurationAllowableActionsBuilder {
    static final AllowableActions NOTHING_ALLOWED = new AllowableActions(){

        public boolean contains(AllowableAction action) {
            return false;
        }

        public Iterator<AllowableAction> iterator() {
            return Collections.emptyIterator();
        }
    };
    private final WebCmsMultiDomainService multiDomainService;
    private final EntityConfigurationAllowableActionsBuilder targetBuilder;

    public AllowableActions getAllowableActions(EntityConfiguration<?> entityConfiguration) {
        WebCmsDomain currentDomain = this.multiDomainService.getCurrentDomain();
        Boolean allowedPerDomain = (Boolean)entityConfiguration.getAttribute("webCmsModule.multiDomain.allowPerDomain", Boolean.class);
        if (this.multiDomainService.isDomainBound(entityConfiguration.getEntityType()) ? WebCmsDomain.isNoDomain(currentDomain) && !this.multiDomainService.isNoDomainAllowed(entityConfiguration.getEntityType()) || Boolean.FALSE.equals(allowedPerDomain) : !WebCmsDomain.isNoDomain(currentDomain) && !Boolean.TRUE.equals(allowedPerDomain)) {
            return NOTHING_ALLOWED;
        }
        return this.targetBuilder.getAllowableActions(entityConfiguration);
    }

    public <V> AllowableActions getAllowableActions(EntityConfiguration<V> entityConfiguration, V entity) {
        WebCmsDomain currentDomain = this.multiDomainService.getCurrentDomain();
        WebCmsDomain entityDomain = this.entityDomain(entityConfiguration, entity);
        Boolean allowedPerDomain = (Boolean)entityConfiguration.getAttribute("webCmsModule.multiDomain.allowPerDomain", Boolean.class);
        if (WebCmsDomain.isNoDomain(entityDomain) ? currentDomain != WebCmsDomain.NONE && !Boolean.TRUE.equals(allowedPerDomain) : !entityDomain.equals(currentDomain)) {
            return NOTHING_ALLOWED;
        }
        return this.targetBuilder.getAllowableActions(entityConfiguration, entity);
    }

    private WebCmsDomain entityDomain(EntityConfiguration entityConfiguration, Object entity) {
        BeanWrapperImpl beanWrapper;
        Object domain;
        String domainProperty = (String)entityConfiguration.getAttribute("webCmsModule.multiDomain.domainProperty", String.class);
        if (domainProperty != null && ((domain = (beanWrapper = new BeanWrapperImpl(entity)).getPropertyValue(domainProperty)) == null || domain instanceof WebCmsDomain)) {
            return (WebCmsDomain)domain;
        }
        return entity instanceof WebCmsDomainBound ? ((WebCmsDomainBound)entity).getDomain() : WebCmsDomain.NONE;
    }

    public CurrentDomainAwareAllowableActionsBuilder(WebCmsMultiDomainService multiDomainService, EntityConfigurationAllowableActionsBuilder targetBuilder) {
        this.multiDomainService = multiDomainService;
        this.targetBuilder = targetBuilder;
    }
}

