/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.validators;

import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.domain.QWebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.querydsl.core.types.Predicate;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsDomainValidator
extends EntityValidatorSupport<WebCmsDomain> {
    private final WebCmsDomainRepository domainRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsDomain.class.isAssignableFrom(clazz);
    }

    protected void postValidation(WebCmsDomain entity, Errors errors, Object ... validationHints) {
        if (!errors.hasFieldErrors("name")) {
            QWebCmsDomain query = QWebCmsDomain.webCmsDomain;
            this.domainRepository.findOne((Predicate)query.name.equalsIgnoreCase(entity.getName())).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("name", "alreadyExists"));
        }
        if (!errors.hasFieldErrors("domainKey")) {
            this.domainRepository.findOneByDomainKey(entity.getDomainKey()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("domainKey", "alreadyExists"));
        }
        if (!errors.hasFieldErrors("domainKey") && !errors.hasFieldErrors("objectId")) {
            this.domainRepository.findOneByObjectId(entity.getObjectId()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("objectId", "alreadyExists"));
        }
    }

    public WebCmsDomainValidator(WebCmsDomainRepository domainRepository) {
        this.domainRepository = domainRepository;
    }
}

