/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainCache;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContextHolder;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainLocaleContextResolver;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractWebCmsDomainContextFilter
extends OncePerRequestFilter {
    public static final String FILTER_NAME = "domainContextFilter";
    private WebCmsDomainCache domainCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean localeSet = false;
        try {
            UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build();
            DomainContextLookup matchingLookup = this.retrieveMatchingLookup(uriComponents);
            if (matchingLookup != null) {
                WebCmsDomainContextHolder.setWebCmsDomainContext(matchingLookup.getDomainContext());
                if (matchingLookup.getLocale() != null) {
                    LocaleContextHolder.setLocale((Locale)matchingLookup.getLocale());
                    request.setAttribute(WebCmsDomainLocaleContextResolver.LOCALE_ATTRIBUTE, (Object)matchingLookup.getLocale());
                    localeSet = true;
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            WebCmsDomainContextHolder.clearWebCmsDomainContext();
            if (localeSet) {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }

    private DomainContextLookup retrieveMatchingLookup(UriComponents uriComponents) {
        String hostNameAndPort = uriComponents.getHost() + (uriComponents.getPort() > 0 ? ":" + uriComponents.getPort() : "");
        HostLookupData lookupData = this.domainCache.getLookupData(HostLookupData.class);
        if (lookupData == null) {
            lookupData = new HostLookupData(this.retrieveLookups());
            this.domainCache.putLookupData(lookupData);
        }
        return lookupData.findDomainContextLookup(hostNameAndPort);
    }

    private List<DomainContextLookup> retrieveLookups() {
        return this.buildDomainSpecificLookups();
    }

    protected abstract List<DomainContextLookup> buildDomainSpecificLookups();

    protected abstract DomainContextLookup buildDefaultDomainLookup(List<DomainContextLookup> var1);

    protected Pattern compileHostPattern(String hostName) {
        String patternString = StringUtils.defaultString((String)hostName).replace(".", "\\.").replace("**", ".+").replace("*", "[^\\.]+");
        if (!hostName.contains(":")) {
            patternString = patternString + "(:\\d+)?";
        }
        return Pattern.compile("^" + patternString + "$", 2);
    }

    @Autowired
    void setDomainCache(WebCmsDomainCache domainCache) {
        this.domainCache = domainCache;
    }

    public static class DomainContextLookup {
        private Pattern hostPattern;
        private Locale locale;
        @NonNull
        private WebCmsDomainContext domainContext;

        public boolean matches(String hostName) {
            return this.hostPattern.matcher(hostName).matches();
        }

        public DomainContextLookup(Pattern hostPattern, Locale locale, @NonNull WebCmsDomainContext domainContext) {
            if (domainContext == null) {
                throw new NullPointerException("domainContext is marked non-null but is null");
            }
            this.hostPattern = hostPattern;
            this.locale = locale;
            this.domainContext = domainContext;
        }

        public Locale getLocale() {
            return this.locale;
        }

        @NonNull
        public WebCmsDomainContext getDomainContext() {
            return this.domainContext;
        }
    }

    class HostLookupData {
        private final Map<String, DomainContextLookup> lookupsByHostName = new ConcurrentHashMap<String, DomainContextLookup>();
        private final List<DomainContextLookup> domainSpecificLookups;
        private DomainContextLookup defaultDomainLookup;

        DomainContextLookup findDomainContextLookup(String hostName) {
            return this.lookupsByHostName.computeIfAbsent(hostName, key -> this.domainSpecificLookups.stream().filter(lookup -> lookup.matches((String)key)).findFirst().orElseGet(this::getDefaultDomainLookup));
        }

        DomainContextLookup getDefaultDomainLookup() {
            if (this.defaultDomainLookup == null) {
                this.defaultDomainLookup = AbstractWebCmsDomainContextFilter.this.buildDefaultDomainLookup(this.domainSpecificLookups);
            }
            return this.defaultDomainLookup;
        }

        public HostLookupData(List<DomainContextLookup> domainSpecificLookups) {
            this.domainSpecificLookups = domainSpecificLookups;
        }
    }
}

