/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainService;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainChangedEvent;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainContextResolver;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieWebCmsDomainContextResolver
extends CookieGenerator
implements WebCmsDomainContextResolver {
    public static final String DEFAULT_COOKIE_NAME = CookieWebCmsDomainContextResolver.class.getName() + ".DOMAIN";
    private static final String NO_DOMAIN_VALUE = "no-domain";
    private final WebCmsDomainService domainService;
    private final ApplicationEventPublisher eventPublisher;

    public CookieWebCmsDomainContextResolver(WebCmsDomainService domainService, ApplicationEventPublisher eventPublisher) {
        this.domainService = domainService;
        this.eventPublisher = eventPublisher;
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    @Override
    public WebCmsDomainContext resolveDomainContext(HttpServletRequest request) {
        String fixedDomainKey = request.getParameter("wcmSelectDomain");
        String objectId = this.retrieveDomainObjectIdFromCookie(request);
        if (NO_DOMAIN_VALUE.equals(fixedDomainKey) || fixedDomainKey == null && NO_DOMAIN_VALUE.equals(objectId)) {
            return WebCmsDomainContext.noDomain(this.domainService.getMetadataForDomain(WebCmsDomain.NONE, Object.class));
        }
        WebCmsDomain domain = this.retrieveDomain(fixedDomainKey, objectId);
        if (domain != null) {
            return new WebCmsDomainContext(domain, this.domainService.getMetadataForDomain(domain, Object.class));
        }
        return null;
    }

    private WebCmsDomain retrieveDomain(String fixedDomainKey, String objectIdFromCookie) {
        WebCmsDomain domain = null;
        if (fixedDomainKey != null) {
            domain = this.domainService.getDomainByKey(fixedDomainKey);
        }
        if (domain == null && objectIdFromCookie != null) {
            domain = this.domainService.getDomain(objectIdFromCookie);
        }
        return domain;
    }

    @Override
    public void setDomainContext(HttpServletRequest request, HttpServletResponse response, WebCmsDomainContext domainContext) {
        String currentValue = this.retrieveDomainObjectIdFromCookie(request);
        if (domainContext != null) {
            String value;
            String string = value = domainContext.holdsDomain() ? domainContext.getDomain().getObjectId() : NO_DOMAIN_VALUE;
            if (!StringUtils.equals((CharSequence)currentValue, (CharSequence)value)) {
                this.addCookie(response, value);
                WebCmsDomainChangedEvent domainChangedEvent = new WebCmsDomainChangedEvent(currentValue, value);
                this.eventPublisher.publishEvent((Object)domainChangedEvent);
            }
        } else if (currentValue != null) {
            this.removeCookie(response);
        }
    }

    private String retrieveDomainObjectIdFromCookie(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        return cookie != null ? cookie.getValue() : null;
    }
}

