/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.modules.web.mvc.condition.AbstractCustomRequestCondition;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainMapping;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.WebCmsConditionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotatedElementUtils;

class WebCmsDomainCondition
extends AbstractCustomRequestCondition<WebCmsDomainCondition> {
    private final WebCmsMultiDomainService multiDomainService;
    private String[] domains = new String[0];

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        WebCmsDomainMapping domainMapping = (WebCmsDomainMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, WebCmsDomainMapping.class);
        this.domains = domainMapping.value();
    }

    protected Collection<?> getContent() {
        return Collections.singletonList(this.domains);
    }

    protected String getToStringInfix() {
        return "";
    }

    public WebCmsDomainCondition combine(WebCmsDomainCondition other) {
        WebCmsDomainCondition result = new WebCmsDomainCondition(this.multiDomainService);
        result.domains = WebCmsConditionUtils.combineArrays(this.domains, other.domains);
        return result;
    }

    public WebCmsDomainCondition getMatchingCondition(HttpServletRequest request) {
        if (this.domains.length == 0) {
            return this;
        }
        WebCmsDomain domain = this.multiDomainService.getCurrentDomain();
        for (String candidate : this.domains) {
            if (candidate == null && domain == null) {
                WebCmsDomainCondition condition = new WebCmsDomainCondition(this.multiDomainService);
                condition.domains = new String[]{null};
                return condition;
            }
            if (domain == null || !domain.getDomainKey().equals(candidate)) continue;
            WebCmsDomainCondition condition = new WebCmsDomainCondition(this.multiDomainService);
            condition.domains = new String[]{candidate};
            return condition;
        }
        return null;
    }

    public int compareTo(WebCmsDomainCondition other, HttpServletRequest request) {
        return WebCmsConditionUtils.compareArrays(this.domains, other.domains);
    }

    public WebCmsDomainCondition(WebCmsMultiDomainService multiDomainService) {
        this.multiDomainService = multiDomainService;
    }
}

