/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.modules.adminweb.menu.AdminMenuEvent;
import com.foreach.across.modules.bootstrapui.components.builder.NavComponentBuilder;
import com.foreach.across.modules.spring.security.actions.AllowableAction;
import com.foreach.across.modules.web.menu.PathBasedMenuBuilder;
import com.foreach.across.modules.webcms.WebCmsModuleIcons;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContextHolder;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainAdminUiService;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import java.util.ArrayList;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Component
class WebCmsDomainNavBuilder {
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
    private final WebCmsDomainRepository domainRepository;
    private final WebCmsMultiDomainAdminUiService adminUiService;

    @EventListener
    void buildDomainSelector(AdminMenuEvent event) {
        if (!this.multiDomainConfiguration.isDisabled() && !this.multiDomainConfiguration.isDomainSelectablePerEntity()) {
            PathBasedMenuBuilder menuBuilder = event.builder().group("/wcmDomain", "#{webCmsModule.menu.domainNav.switchDomain=Switch domain}").attribute("nav:icon", (Object)WebCmsModuleIcons.webCmsIcons.menu.domainGroup()).attribute("nav:iconOnly", (Object)true).attribute("adminMenu:position", (Object)"navbar-right").and();
            WebCmsDomainContext domainContext = WebCmsDomainContextHolder.getWebCmsDomainContext();
            WebCmsDomain currentDomain = domainContext != null ? domainContext.getDomain() : null;
            ArrayList<WebCmsDomain> accessibleDomains = new ArrayList<WebCmsDomain>(this.adminUiService.getAccessibleDomains(AllowableAction.READ));
            boolean noDomainAllowed = accessibleDomains.remove(WebCmsDomain.NONE);
            if (noDomainAllowed) {
                PathBasedMenuBuilder.PathBasedMenuItemBuilder itemBuilder = menuBuilder.item("/wcmDomain/no-domain", "#{webCmsModule.menu.domainNav.noDomain=Shared settings}", "@adminWeb:/?ts=" + System.currentTimeMillis() + "&wcmSelectDomain=no-domain").attribute("nav:insertSeparator", (Object)NavComponentBuilder.Separator.AFTER).order(Integer.MIN_VALUE);
                if (WebCmsDomain.isNoDomain(currentDomain)) {
                    itemBuilder.attribute("nav:icon", (Object)WebCmsModuleIcons.webCmsIcons.menu.selectedDomain());
                }
            }
            accessibleDomains.forEach(domain -> {
                PathBasedMenuBuilder.PathBasedMenuItemBuilder item = menuBuilder.item("/wcmDomain/" + domain.getId(), domain.getName(), "@adminWeb:/?ts=" + System.currentTimeMillis() + "&wcmSelectDomain=" + domain.getDomainKey());
                if (domain.equals(currentDomain)) {
                    item.attribute("nav:icon", (Object)WebCmsModuleIcons.webCmsIcons.menu.selectedDomain());
                    menuBuilder.root("/").title(domain.getName()).attribute("nav:iconOnly", (Object)false);
                }
            });
        }
    }

    public WebCmsDomainNavBuilder(WebCmsMultiDomainConfiguration multiDomainConfiguration, WebCmsDomainRepository domainRepository, WebCmsMultiDomainAdminUiService adminUiService) {
        this.multiDomainConfiguration = multiDomainConfiguration;
        this.domainRepository = domainRepository;
        this.adminUiService = adminUiService;
    }
}

