/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.foreach.across.modules.webcms.domain.domain.web.AbstractWebCmsDomainContextFilter;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsSiteConfiguration;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class WebCmsSiteConfigurationFilter
extends AbstractWebCmsDomainContextFilter {
    private WebCmsDomainRepository domainRepository;
    private WebCmsMultiDomainService multiDomainService;
    private WebCmsMultiDomainConfiguration multiDomainConfiguration;

    @Override
    protected List<AbstractWebCmsDomainContextFilter.DomainContextLookup> buildDomainSpecificLookups() {
        return this.domainRepository.findAll().stream().filter(WebCmsDomain::isActive).map(domain -> this.multiDomainService.getMetadataForDomain((WebCmsDomain)domain, Object.class)).filter(metadata -> metadata instanceof WebCmsSiteConfiguration).map(WebCmsSiteConfiguration.class::cast).sorted(Comparator.comparing(WebCmsSiteConfiguration::getSortIndex)).flatMap(site -> site.getHostNames().stream().map(hostName -> this.createDomainContextLookup((String)hostName, site.getDomain(), site))).collect(Collectors.toList());
    }

    @Override
    protected AbstractWebCmsDomainContextFilter.DomainContextLookup buildDefaultDomainLookup(List<AbstractWebCmsDomainContextFilter.DomainContextLookup> domainSpecificLookups) {
        String defaultDomainKey = this.multiDomainConfiguration.getDefaultDomainKey();
        WebCmsDomain domain = defaultDomainKey != null ? this.multiDomainService.getDomainByKey(defaultDomainKey) : WebCmsDomain.NONE;
        Object metadata = this.multiDomainService.getMetadataForDomain(domain, Object.class);
        return this.createDomainContextLookup(null, domain, metadata);
    }

    protected AbstractWebCmsDomainContextFilter.DomainContextLookup createDomainContextLookup(String hostName, WebCmsDomain domain, Object metadata) {
        Pattern hostPattern = null;
        Locale localeToUse = null;
        if (hostName != null) {
            hostPattern = this.compileHostPattern(hostName);
        }
        if (metadata instanceof WebCmsSiteConfiguration) {
            WebCmsSiteConfiguration siteConfiguration = (WebCmsSiteConfiguration)metadata;
            localeToUse = hostName != null ? siteConfiguration.getLocaleForHostName(hostName) : siteConfiguration.getDefaultLocale();
        }
        WebCmsDomainContext domainContext = domain != null ? new WebCmsDomainContext(domain, metadata) : WebCmsDomainContext.noDomain(metadata);
        return new AbstractWebCmsDomainContextFilter.DomainContextLookup(hostPattern, localeToUse, domainContext);
    }

    @Autowired
    void setDomainRepository(WebCmsDomainRepository domainRepository) {
        this.domainRepository = domainRepository;
    }

    @Autowired
    void setMultiDomainService(WebCmsMultiDomainService multiDomainService) {
        this.multiDomainService = multiDomainService;
    }

    @Autowired
    void setMultiDomainConfiguration(WebCmsMultiDomainConfiguration multiDomainConfiguration) {
        this.multiDomainConfiguration = multiDomainConfiguration;
    }
}

