/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.domain.web;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainAware;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsSiteConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Exposed
@Component
@Scope(value="prototype")
public class WebCmsSiteConfigurationImpl
implements WebCmsSiteConfiguration,
WebCmsDomainAware {
    private static final TypeDescriptor HOST_NAMES_TYPE = TypeDescriptor.collection(List.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class));
    private static final TypeDescriptor LOCALES_TYPE = TypeDescriptor.map(HashMap.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class), (TypeDescriptor)TypeDescriptor.valueOf(Locale.class));
    private static final String HOST_NAMES = "hostNames";
    private static final String COOKIE_DOMAIN = "cookieDomain";
    private static final String DEFAULT_LOCALE = "defaultLocale";
    private static final String SORT_INDEX = "sortIndex";
    private static final String LOCALES = "locales";
    private static final String URL_PREFIX = "urlPrefix";
    private static final String ALWAYS_PREFIX = "alwaysPrefix";
    private final WebCmsDataConversionService dataConversionService;
    private WebCmsDomain domain;
    private List<String> hostNames;
    private Map<String, Locale> locales;
    private String cookieDomain;
    private Locale defaultLocale;
    private int sortIndex;
    private String urlPrefix;
    private boolean alwaysPrefix;

    @Override
    public void setWebCmsDomain(WebCmsDomain domain) {
        Assert.notNull((Object)domain, (String)"A non-null domain is required");
        this.domain = domain;
        this.cookieDomain = this.getAttribute(COOKIE_DOMAIN, String.class);
        this.sortIndex = this.getAttribute(SORT_INDEX, Integer.TYPE, Integer.valueOf(0));
        this.defaultLocale = this.getAttribute(DEFAULT_LOCALE, Locale.class);
        this.hostNames = this.getAttribute(HOST_NAMES, HOST_NAMES_TYPE, Collections.emptyList());
        this.locales = this.getAttribute(LOCALES, LOCALES_TYPE, Collections.emptyMap());
        this.urlPrefix = this.getAttribute(URL_PREFIX);
        this.alwaysPrefix = this.getAttribute(ALWAYS_PREFIX, Boolean.TYPE, Boolean.valueOf(false));
    }

    @Override
    public WebCmsDomain getDomain() {
        return this.domain;
    }

    @Override
    public String getDomainKey() {
        return this.domain.getDomainKey();
    }

    @Override
    public String getName() {
        return this.domain.getName();
    }

    @Override
    public List<String> getHostNames() {
        return this.hostNames;
    }

    @Override
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Map<String, Locale> getLocales() {
        return this.locales;
    }

    @Override
    public Locale getLocaleForHostName(String hostName) {
        return this.locales.containsKey(hostName) ? this.locales.get(hostName) : this.getDefaultLocale();
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public final String getAttribute(String attributeName) {
        return this.domain.getAttribute(attributeName);
    }

    @Override
    public final <Y> Y getAttribute(String attributeName, Class<Y> attributeType) {
        return this.getAttribute(attributeName, attributeType, null);
    }

    @Override
    public final <Y> Y getAttribute(String attributeName, TypeDescriptor attributeType, Y defaultValue) {
        String attributeValue = this.domain.getAttribute(attributeName);
        return attributeValue != null ? this.readAttribute(attributeValue, attributeType) : defaultValue;
    }

    @Override
    public final <Y> Y getAttribute(String attributeName, Class<Y> attributeType, Y defaultValue) {
        String attributeValue = this.domain.getAttribute(attributeName);
        return attributeValue != null ? this.readAttribute(attributeValue, TypeDescriptor.valueOf(attributeType)) : defaultValue;
    }

    private <Y> Y readAttribute(String attributeValue, TypeDescriptor attributeType) {
        return (Y)this.dataConversionService.convert(attributeValue, attributeType);
    }

    @Override
    public final boolean hasAttribute(String attributeName) {
        return this.domain.hasAttribute(attributeName);
    }

    @Override
    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    @Override
    public boolean isAlwaysPrefix() {
        return this.alwaysPrefix;
    }

    public WebCmsSiteConfigurationImpl(WebCmsDataConversionService dataConversionService) {
        this.dataConversionService = dataConversionService;
    }
}

