/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint;

import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="wcm_endpoint")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NotThreadSafe
public abstract class WebCmsEndpoint
extends SettableIdBasedEntity<WebCmsEndpoint>
implements WebCmsDomainBound {
    @Id
    @GeneratedValue(generator="seq_wcm_endpoint_id")
    @GenericGenerator(name="seq_wcm_endpoint_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_endpoint_id"), @Parameter(name="allocationSize", value="10")})
    @Column(name="id")
    protected Long id;
    @ManyToOne
    @JoinColumn(name="domain_id")
    private WebCmsDomain domain;
    @Cascade(value={CascadeType.DELETE})
    @OneToMany(mappedBy="endpoint")
    protected Collection<WebCmsUrl> urls = Collections.emptySet();

    public Optional<WebCmsUrl> getPrimaryUrl() {
        return this.getUrls().stream().filter(WebCmsUrl::isPrimary).findFirst();
    }

    public Optional<WebCmsUrl> getUrlWithPath(String path) {
        return this.getUrls().stream().filter(url -> StringUtils.equalsIgnoreCase((CharSequence)url.getPath(), (CharSequence)path)).findFirst();
    }

    public WebCmsEndpoint() {
    }

    private WebCmsEndpoint(Long id, WebCmsDomain domain, Collection<WebCmsUrl> urls) {
        this.id = id;
        this.domain = domain;
        this.urls = urls;
    }

    public Long getId() {
        return this.id;
    }

    public Collection<WebCmsUrl> getUrls() {
        return this.urls;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUrls(Collection<WebCmsUrl> urls) {
        this.urls = urls;
    }

    @Override
    public WebCmsDomain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(WebCmsDomain domain) {
        this.domain = domain;
    }
}

