/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.support.EndpointModificationType;
import com.foreach.across.modules.webcms.domain.endpoint.support.PrimaryUrlForAssetFailedEvent;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrlCache;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import com.foreach.across.modules.webcms.infrastructure.ModificationReport;
import com.foreach.across.modules.webcms.infrastructure.ModificationStatus;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class WebCmsEndpointServiceImpl
implements WebCmsEndpointService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsEndpointServiceImpl.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsUrlRepository urlRepository;
    private final WebCmsUrlCache urlCache;
    private final ApplicationEventPublisher eventPublisher;
    private final WebCmsMultiDomainService multiDomainService;

    @Override
    public Optional<WebCmsUrl> getUrlForPath(String path) {
        return this.getUrlForPathAndDomain(path, this.multiDomainService.getCurrentDomainForType(WebCmsEndpoint.class));
    }

    @Override
    public Optional<WebCmsUrl> getUrlForPathAndDomain(String path, WebCmsDomain domain) {
        return this.urlCache.getUrlForPathAndDomain(path, domain);
    }

    @Override
    @Transactional
    public ModificationReport<EndpointModificationType, WebCmsUrl> updateOrCreatePrimaryUrlForAsset(String primaryUrl, WebCmsAsset asset, boolean publishEventOnFailure) {
        boolean canBeUpdated = asset.getPublicationDate() == null || new Date().before(asset.getPublicationDate());
        WebCmsDomain domain = this.multiDomainService.isDomainBound(WebCmsAssetEndpoint.class) ? asset.getDomain() : WebCmsDomain.NONE;
        WebCmsAssetEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(asset, domain).orElse(null);
        if (endpoint != null) {
            Optional<WebCmsUrl> currentUrl = endpoint.getPrimaryUrl();
            if (currentUrl.isPresent() && currentUrl.get().isPrimaryLocked() && currentUrl.get().isPrimary()) {
                return new ModificationReport<EndpointModificationType, Object>(EndpointModificationType.PRIMARY_URL_UPDATED, ModificationStatus.SKIPPED, currentUrl.get(), null);
            }
            WebCmsUrl newPrimaryUrl = new WebCmsUrl();
            newPrimaryUrl.setPath(primaryUrl);
            newPrimaryUrl.setHttpStatus(HttpStatus.OK);
            newPrimaryUrl.setPrimary(true);
            newPrimaryUrl.setEndpoint(endpoint);
            WebCmsUrl existing = this.urlRepository.findOneByPathAndEndpoint_Domain(primaryUrl, domain).orElse(null);
            if (existing != null && !endpoint.equals(existing.getEndpoint())) {
                ModificationReport<EndpointModificationType, WebCmsUrl> modificationReport = new ModificationReport<EndpointModificationType, WebCmsUrl>(EndpointModificationType.PRIMARY_URL_UPDATED, ModificationStatus.FAILED, currentUrl.orElse(null), newPrimaryUrl);
                LOG.warn("Unable to update primary URL for {} - another asset already uses path {}", (Object)asset, (Object)existing.getPath());
                if (publishEventOnFailure) {
                    PrimaryUrlForAssetFailedEvent event = new PrimaryUrlForAssetFailedEvent(asset, endpoint, modificationReport);
                    this.eventPublisher.publishEvent((Object)event);
                    modificationReport = event.getModificationReport();
                }
                return modificationReport;
            }
            if (existing != null && !existing.isPrimary()) {
                newPrimaryUrl = (WebCmsUrl)existing.toDto();
                newPrimaryUrl.setPrimary(true);
                newPrimaryUrl.setHttpStatus(HttpStatus.OK);
            }
            if (existing == null || !existing.isPrimary()) {
                AtomicReference primaryUpdated = new AtomicReference();
                currentUrl.ifPresent(currentPrimaryUrl -> {
                    WebCmsUrl update = (WebCmsUrl)currentPrimaryUrl.toDto();
                    if (canBeUpdated) {
                        update.setPath(primaryUrl);
                        primaryUpdated.set(update);
                    } else {
                        update.setPrimary(false);
                        update.setHttpStatus(HttpStatus.MOVED_PERMANENTLY);
                    }
                    this.urlRepository.save((Object)update);
                });
                if (primaryUpdated.get() == null) {
                    this.urlRepository.save((Object)newPrimaryUrl);
                    return new ModificationReport<EndpointModificationType, WebCmsUrl>(EndpointModificationType.PRIMARY_URL_UPDATED, ModificationStatus.SUCCESSFUL, currentUrl.orElse(null), newPrimaryUrl);
                }
                return new ModificationReport<EndpointModificationType, Object>(EndpointModificationType.PRIMARY_URL_UPDATED, ModificationStatus.SUCCESSFUL, currentUrl.orElse(null), primaryUpdated.get());
            }
        }
        return new ModificationReport<EndpointModificationType, Object>(EndpointModificationType.PRIMARY_URL_UPDATED, ModificationStatus.SKIPPED, null, null);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<WebCmsUrl> getPrimaryUrlForAsset(WebCmsAsset asset) {
        return this.getPrimaryUrlForAssetOnDomain(asset, this.multiDomainService.getCurrentDomainForEntity(asset));
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<WebCmsUrl> getPrimaryUrlForAssetOnDomain(WebCmsAsset asset, WebCmsDomain domain) {
        return this.assetEndpointRepository.findOneByAssetAndDomain(asset, domain).map(e -> e.getPrimaryUrl().orElse(null));
    }

    @Override
    public UriComponentsBuilder appendPreviewCode(WebCmsEndpoint endpoint, UriComponentsBuilder uriComponentsBuilder) {
        return uriComponentsBuilder.queryParam("wcmPreview", new Object[]{DigestUtils.md5DigestAsHex((byte[])endpoint.getId().toString().getBytes(UTF8))});
    }

    @Override
    public boolean isValidPreviewCode(WebCmsEndpoint endpoint, String securityCode) {
        return !StringUtils.isEmpty((CharSequence)securityCode) && DigestUtils.md5DigestAsHex((byte[])endpoint.getId().toString().getBytes(UTF8)).equals(securityCode);
    }

    public WebCmsEndpointServiceImpl(WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsUrlRepository urlRepository, WebCmsUrlCache urlCache, ApplicationEventPublisher eventPublisher, WebCmsMultiDomainService multiDomainService) {
        this.assetEndpointRepository = assetEndpointRepository;
        this.urlRepository = urlRepository;
        this.urlCache = urlCache;
        this.eventPublisher = eventPublisher;
        this.multiDomainService = multiDomainService;
    }
}

