/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.domain.web.WebCmsDomainUrlConfigurer;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsUriComponentsService;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

@Service
class WebCmsUriComponentsServiceImpl
implements WebCmsUriComponentsService {
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;

    @Override
    @Transactional(readOnly=true)
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsAsset asset) {
        Assert.notNull((Object)asset, (String)"asset is required");
        return this.buildUriComponents(asset, this.resolveDomain(asset));
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsAsset asset, WebCmsDomain domain) {
        Assert.notNull((Object)asset, (String)"asset is required");
        WebCmsEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(asset, domain).orElse(null);
        if (endpoint != null) {
            return this.buildUriComponents(endpoint, domain);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsEndpoint endpoint) {
        if (endpoint != null) {
            return this.buildUriComponents(endpoint, this.resolveDomain(endpoint));
        }
        return Optional.empty();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsEndpoint endpoint, WebCmsDomain domain) {
        if (endpoint != null) {
            return endpoint.getPrimaryUrl().flatMap(url -> this.buildUriComponents((WebCmsUrl)((Object)url), domain));
        }
        return Optional.empty();
    }

    @Override
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsUrl url) {
        if (url != null) {
            return this.buildUriComponents(url, this.resolveDomain(url.getEndpoint()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<UriComponentsBuilder> buildUriComponents(WebCmsUrl url, WebCmsDomain domain) {
        if (url != null) {
            boolean shouldPrefix;
            Object metadataForDomain = this.multiDomainService.getMetadataForDomain(domain, Object.class);
            WebCmsDomainUrlConfigurer urlConfigurer = metadataForDomain instanceof WebCmsDomainUrlConfigurer ? (WebCmsDomainUrlConfigurer)metadataForDomain : null;
            boolean bl = shouldPrefix = this.multiDomainService.isCurrentDomain(domain) && urlConfigurer != null && urlConfigurer.isAlwaysPrefix();
            if (!shouldPrefix) {
                return Optional.of(UriComponentsBuilder.fromUriString((String)url.getPath()));
            }
            String prefix = StringUtils.defaultString((String)urlConfigurer.getUrlPrefix(), (String)"");
            return Optional.of(UriComponentsBuilder.fromUriString((String)prefix).path(url.getPath()));
        }
        return Optional.empty();
    }

    private WebCmsDomain resolveDomain(WebCmsDomainBound object) {
        Assert.notNull((Object)object, (String)"object is required");
        if (this.multiDomainService.isDomainBound(object)) {
            if (!WebCmsDomain.isNoDomain(object.getDomain())) {
                return object.getDomain();
            }
            return this.multiDomainService.getCurrentDomain();
        }
        return WebCmsDomain.NONE;
    }

    public WebCmsUriComponentsServiceImpl(WebCmsMultiDomainService multiDomainService, WebCmsAssetEndpointRepository assetEndpointRepository) {
        this.multiDomainService = multiDomainService;
        this.assetEndpointRepository = assetEndpointRepository;
    }
}

