/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.config;

import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import java.util.Locale;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Configuration
class WebCmsEndpointConfiguration
implements EntityConfigurer {
    private final EndpointPrinter endpointPrinter;

    public void configure(EntitiesConfigurationBuilder entities) {
        entities.withType(WebCmsEndpoint.class).entityModel(model -> model.labelPrinter((Printer)this.endpointPrinter));
    }

    public WebCmsEndpointConfiguration(EndpointPrinter endpointPrinter) {
        this.endpointPrinter = endpointPrinter;
    }

    @ConditionalOnAdminUI
    @Component
    static class EndpointPrinter
    implements Printer<WebCmsEndpoint> {
        private final EntityRegistry entityRegistry;

        public String print(WebCmsEndpoint object, Locale locale) {
            EntityConfiguration actualConfig;
            Class actualType = Hibernate.getClass((Object)object);
            EntityConfiguration baseConfig = this.entityRegistry.getEntityConfiguration(WebCmsEndpoint.class);
            if (baseConfig != (actualConfig = this.entityRegistry.getEntityConfiguration(actualType))) {
                return actualConfig.getEntityModel().getLabel((Object)this.actualEntity(object), locale);
            }
            return object.toString();
        }

        private WebCmsEndpoint actualEntity(WebCmsEndpoint endpoint) {
            if (endpoint instanceof HibernateProxy) {
                return (WebCmsEndpoint)((HibernateProxy)endpoint).getHibernateLazyInitializer().getImplementation();
            }
            return endpoint;
        }

        public EndpointPrinter(EntityRegistry entityRegistry) {
            this.entityRegistry = entityRegistry;
        }
    }
}

