/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.config;

import java.util.Collection;
import java.util.Collections;
import lombok.NonNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
@ConfigurationProperties(value="web-cms-module.urls")
public class WebCmsEndpointMappingConfiguration {
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    @NonNull
    private Collection<String> includedPathPatterns = Collections.emptyList();
    @NonNull
    private Collection<String> excludedPathPatterns = Collections.emptyList();

    public boolean shouldMapToWebCmsUrl(String path) {
        if (path != null) {
            for (String excluded : this.excludedPathPatterns) {
                if (!this.antPathMatcher.match(excluded, path)) continue;
                return false;
            }
            if (this.includedPathPatterns.isEmpty()) {
                return true;
            }
            for (String included : this.includedPathPatterns) {
                if (!this.antPathMatcher.match(included, path)) continue;
                return true;
            }
        }
        return false;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    @NonNull
    public Collection<String> getIncludedPathPatterns() {
        return this.includedPathPatterns;
    }

    @NonNull
    public Collection<String> getExcludedPathPatterns() {
        return this.excludedPathPatterns;
    }

    public void setIncludedPathPatterns(@NonNull Collection<String> includedPathPatterns) {
        if (includedPathPatterns == null) {
            throw new NullPointerException("includedPathPatterns is marked non-null but is null");
        }
        this.includedPathPatterns = includedPathPatterns;
    }

    public void setExcludedPathPatterns(@NonNull Collection<String> excludedPathPatterns) {
        if (excludedPathPatterns == null) {
            throw new NullPointerException("excludedPathPatterns is marked non-null but is null");
        }
        this.excludedPathPatterns = excludedPathPatterns;
    }
}

