/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.web;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.config.WebCmsEndpointMappingConfiguration;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointAccessValidator;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointContextResolver;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UrlPathHelper;

@Component
@Exposed
public class DefaultWebCmsEndpointContextResolver
implements WebCmsEndpointContextResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebCmsEndpointContextResolver.class);
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private final WebCmsEndpointService endpointService;
    private final WebCmsEndpointMappingConfiguration endpointMappingConfiguration;
    private Collection<WebCmsEndpointAccessValidator<?>> endpointAccessValidators = Collections.emptyList();

    @Override
    public void resolve(ConfigurableWebCmsEndpointContext context, HttpServletRequest request) {
        context.setResolved(true);
        String path = this.pathHelper.getPathWithinApplication(request);
        if (this.endpointMappingConfiguration.shouldMapToWebCmsUrl(path)) {
            LOG.trace("Resolving path for {}", (Object)path);
            this.endpointService.getUrlForPath(path).ifPresent(url -> this.resolve(context, (WebCmsUrl)((Object)url), request));
            LOG.trace("Context after resolving {}", (Object)context);
        } else {
            LOG.trace("Ignoring request path for WebCmsUrl mapping: {}", (Object)path);
        }
    }

    private void resolve(ConfigurableWebCmsEndpointContext context, WebCmsUrl url, HttpServletRequest request) {
        WebCmsEndpoint endpoint = url.getEndpoint();
        LOG.trace("Found {} as endpoint", (Object)endpoint);
        if (this.validateAccess(endpoint)) {
            context.setUrl(url);
            context.setEndpoint(endpoint);
        } else if (this.isPreviewRequest(endpoint, request)) {
            context.setPreviewMode(true);
            context.setUrl(url);
            context.setEndpoint(endpoint);
        } else {
            LOG.trace("Not using endpoint {} as the responsible validator vetoed and no valid preview mode.", (Object)endpoint);
        }
    }

    private boolean validateAccess(WebCmsEndpoint endpoint) {
        for (WebCmsEndpointAccessValidator<?> validator : this.endpointAccessValidators) {
            if (!validator.appliesFor(endpoint)) continue;
            return validator.validateAccess(endpoint);
        }
        return true;
    }

    private boolean isPreviewRequest(WebCmsEndpoint endpoint, HttpServletRequest request) {
        boolean previewMode;
        String securityCode = request.getParameter("wcmPreview");
        boolean bl = previewMode = !StringUtils.isEmpty((CharSequence)securityCode) && this.endpointService.isValidPreviewCode(endpoint, securityCode);
        if (previewMode) {
            LOG.trace("Activating preview mode for endpoint {} - security code {}", (Object)endpoint, (Object)securityCode);
        }
        return previewMode;
    }

    @Autowired
    void setEndpointAccessValidators(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsEndpointAccessValidator<?>> endpointAccessValidators) {
        this.endpointAccessValidators = endpointAccessValidators;
    }

    public DefaultWebCmsEndpointContextResolver(WebCmsEndpointService endpointService, WebCmsEndpointMappingConfiguration endpointMappingConfiguration) {
        this.endpointService = endpointService;
        this.endpointMappingConfiguration = endpointMappingConfiguration;
    }
}

