/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.web;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointModelLoader;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.WebCmsEndpointContext;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@Exposed
@ControllerAdvice
public final class WebCmsEndpointControllerAdvice
implements Ordered {
    public static final String LOAD_ENDPOINT_MODEL_ATTRIBUTE = WebCmsEndpointControllerAdvice.class.getName() + ".LOAD_ENDPOINT_MODEL";
    private final WebCmsEndpointContext context;
    private Collection<WebCmsEndpointModelLoader> endpointModelLoaders = Collections.emptyList();
    private int order = Integer.MIN_VALUE;

    @ModelAttribute(binding=false)
    public void loadEndpointData(HttpServletRequest request, Model model) {
        if (this.context.isAvailable() && Boolean.TRUE.equals(request.getAttribute(LOAD_ENDPOINT_MODEL_ATTRIBUTE))) {
            for (WebCmsEndpointModelLoader loader : this.endpointModelLoaders) {
                if (loader.loadModel(request, this.context, model)) continue;
                return;
            }
        }
    }

    @Autowired
    void setEndpointModelLoaders(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsEndpointModelLoader> endpointModelLoaders) {
        this.endpointModelLoaders = endpointModelLoaders;
    }

    public WebCmsEndpointControllerAdvice(WebCmsEndpointContext context) {
        this.context = context;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

