/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.web.context;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import lombok.NonNull;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
@Exposed
public class DefaultWebCmsEndpointContext
implements ConfigurableWebCmsEndpointContext {
    private WebCmsUrl url;
    private WebCmsEndpoint endpoint;
    private boolean resolved = false;
    private boolean previewMode = false;

    @Override
    public <T extends WebCmsEndpoint> T getEndpoint(Class<T> endpointType) {
        return (T)((WebCmsEndpoint)endpointType.cast(this.getEndpoint()));
    }

    @Override
    public boolean isAvailable() {
        return this.url != null && this.endpoint != null && this.resolved;
    }

    @Override
    public <T extends WebCmsEndpoint> boolean isOfType(@NonNull Class<T> endpointType) {
        if (endpointType == null) {
            throw new NullPointerException("endpointType is marked non-null but is null");
        }
        return this.isAvailable() && endpointType.isInstance(this.endpoint);
    }

    @Override
    public WebCmsUrl getUrl() {
        return this.url;
    }

    @Override
    public WebCmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean isPreviewMode() {
        return this.previewMode;
    }

    @Override
    public void setUrl(WebCmsUrl url) {
        this.url = url;
    }

    @Override
    public void setEndpoint(WebCmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public void setPreviewMode(boolean previewMode) {
        this.previewMode = previewMode;
    }

    public String toString() {
        return "DefaultWebCmsEndpointContext(url=" + (Object)((Object)this.getUrl()) + ", endpoint=" + this.getEndpoint() + ", resolved=" + this.isResolved() + ", previewMode=" + this.isPreviewMode() + ")";
    }
}

