/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.web.controllers;

import com.foreach.across.modules.web.mvc.condition.AbstractCustomRequestCondition;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointContextResolver;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.InvalidWebCmsConditionCombination;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.WebCmsEndpointMapping;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class WebCmsEndpointCondition
extends AbstractCustomRequestCondition<WebCmsEndpointCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsEndpointCondition.class);
    private final ConfigurableWebCmsEndpointContext context;
    private final WebCmsEndpointContextResolver resolver;
    private Class<? extends WebCmsEndpoint> endpointType = WebCmsEndpoint.class;
    private HttpStatus[] statuses = new HttpStatus[0];
    private HttpStatus.Series[] series = new HttpStatus.Series[0];

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        WebCmsEndpointMapping endpointMapping = (WebCmsEndpointMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, WebCmsEndpointMapping.class);
        Assert.notNull((Object)endpointMapping, (String)"no WebCmsEndpointMapping foundon the annotated element");
        this.endpointType = endpointMapping.value();
        this.statuses = endpointMapping.status();
        this.series = endpointMapping.series();
    }

    protected Collection<?> getContent() {
        return Arrays.asList(this.endpointType, this.statuses, this.series);
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public WebCmsEndpointCondition combine(WebCmsEndpointCondition other) {
        WebCmsEndpointCondition result = new WebCmsEndpointCondition(this.context, this.resolver);
        if (this.endpointType.isAssignableFrom(other.endpointType)) {
            result.endpointType = other.endpointType;
        } else {
            if (!other.endpointType.isAssignableFrom(this.endpointType)) {
                String message = String.format("A condition with endpoint type %s and type %s cannot be merged", this.endpointType, other.endpointType);
                throw new InvalidWebCmsConditionCombination(message);
            }
            result.endpointType = this.endpointType;
        }
        result.statuses = this.intersect(this.statuses, other.statuses, this.series, other.series);
        result.series = this.intersect(this.series, other.series);
        return result;
    }

    public WebCmsEndpointCondition getMatchingCondition(HttpServletRequest request) {
        if (!this.context.isResolved()) {
            this.resolver.resolve(this.context, request);
        }
        if (this.endpointType.isInstance(this.context.getEndpoint()) && this.hasCorrectStatus(this.context.getUrl().getHttpStatus())) {
            WebCmsEndpointCondition result = new WebCmsEndpointCondition(this.context, this.resolver);
            result.endpointType = this.endpointType;
            if (this.series.length == 0) {
                result.statuses = new HttpStatus[]{this.context.getUrl().getHttpStatus()};
            } else {
                result.series = new HttpStatus.Series[]{this.context.getUrl().getHttpStatus().series()};
            }
            LOG.trace("Matching condition is {}", (Object)result);
            return result;
        }
        return null;
    }

    public int compareTo(WebCmsEndpointCondition other, HttpServletRequest request) {
        if (this.endpointType != null && other.endpointType != null && !this.endpointType.equals(other.endpointType)) {
            return this.endpointType.isAssignableFrom(other.endpointType) ? 1 : -1;
        }
        if (this.statuses != null && other.statuses != null && this.statuses.length != other.statuses.length) {
            return this.statuses.length > other.statuses.length ? 1 : -1;
        }
        if (this.series != null && other.series != null && this.series.length != other.series.length) {
            return this.series.length > other.series.length ? 1 : -1;
        }
        return 0;
    }

    private HttpStatus[] intersect(HttpStatus[] first, HttpStatus[] other, HttpStatus.Series[] firstSeries, HttpStatus.Series[] otherSeries) {
        if (first.length == 0 || other.length == 0) {
            return first.length == 0 ? other : first;
        }
        HashSet<HttpStatus> result = new HashSet<HttpStatus>(Arrays.asList(first));
        result.retainAll(new HashSet<HttpStatus>(Arrays.asList(other)));
        this.addStatusIfIntersectSeries(firstSeries, first, other, result);
        this.addStatusIfIntersectSeries(otherSeries, first, other, result);
        return result.toArray(new HttpStatus[result.size()]);
    }

    private void addStatusIfIntersectSeries(HttpStatus.Series[] firstSeries, HttpStatus[] first, HttpStatus[] other, Set<HttpStatus> result) {
        for (HttpStatus.Series serie : firstSeries) {
            for (HttpStatus status : first) {
                this.addStatusIfInSeries(result, serie, status);
            }
            for (HttpStatus status : other) {
                this.addStatusIfInSeries(result, serie, status);
            }
        }
    }

    private void addStatusIfInSeries(Set<HttpStatus> s1, HttpStatus.Series serie, HttpStatus status) {
        if (status.series().equals((Object)serie)) {
            s1.add(status);
        }
    }

    private HttpStatus.Series[] intersect(HttpStatus.Series[] first, HttpStatus.Series[] other) {
        if (first.length == 0 || other.length == 0) {
            return first.length == 0 ? other : first;
        }
        HashSet<HttpStatus.Series> result = new HashSet<HttpStatus.Series>(Arrays.asList(first));
        result.retainAll(new HashSet<HttpStatus.Series>(Arrays.asList(other)));
        return result.toArray(new HttpStatus.Series[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasCorrectStatus(HttpStatus currentStatus) {
        currentSeries = currentStatus.series();
        if (this.series.length == 0) ** GOTO lbl-1000
        if (Stream.of(this.series).anyMatch((Predicate<HttpStatus.Series>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/springframework/http/HttpStatus$Series;)Z)((HttpStatus.Series)currentSeries))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = seriesMatch = false;
        }
        if (this.statuses.length == 0) ** GOTO lbl-1000
        if (Stream.of(this.statuses).anyMatch((Predicate<HttpStatus>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/springframework/http/HttpStatus;)Z)((HttpStatus)currentStatus))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        statusMatch = v1;
        return seriesMatch != false && statusMatch != false;
    }

    public WebCmsEndpointCondition(ConfigurableWebCmsEndpointContext context, WebCmsEndpointContextResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }
}

