/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.endpoint.web.interceptor;

import com.foreach.across.modules.web.events.BuildTemplateWebResourcesEvent;
import com.foreach.across.modules.web.resource.WebResource;
import com.foreach.across.modules.web.resource.WebResourceRule;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.webcms.domain.endpoint.web.IgnoreEndpointModel;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointControllerAdvice;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.WebCmsEndpointContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class WebCmsEndpointHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsEndpointHandlerInterceptor.class);
    public static final String DEFAULT_TEMPLATE_ATTRIBUTE = WebCmsEndpointHandlerInterceptor.class.getName() + ".DEFAULT_TEMPLATE";
    private final WebCmsEndpointContext context;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.context.isAvailable()) {
            response.setStatus(this.context.getUrl().getHttpStatus().value());
            if (this.context.isPreviewMode()) {
                response.setHeader("X-WCM-Preview", "true");
            }
            if (!this.shouldEndpointModelBeIgnored(handler)) {
                request.setAttribute(WebCmsEndpointControllerAdvice.LOAD_ENDPOINT_MODEL_ATTRIBUTE, (Object)true);
            }
        }
        return true;
    }

    private boolean shouldEndpointModelBeIgnored(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            IgnoreEndpointModel ignoreAnnotation = (IgnoreEndpointModel)handlerMethod.getMethodAnnotation(IgnoreEndpointModel.class);
            if (ignoreAnnotation == null) {
                Class controllerClass = handlerMethod.getBeanType();
                ignoreAnnotation = (IgnoreEndpointModel)AnnotationUtils.findAnnotation((Class)controllerClass, IgnoreEndpointModel.class);
            }
            return ignoreAnnotation != null;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String defaultTemplate = (String)request.getAttribute(DEFAULT_TEMPLATE_ATTRIBUTE);
            if (handlerMethod.getReturnType().getMethod().getReturnType().equals(Void.TYPE) && defaultTemplate != null) {
                LOG.trace("Applying default template {} as viewName since handler method had a void return type", (Object)defaultTemplate);
                modelAndView.setViewName(defaultTemplate);
            }
        }
    }

    @EventListener
    public void registerPreviewModeWebResources(BuildTemplateWebResourcesEvent webResourcesEvent) {
        if (this.context.isAvailable() && this.context.isPreviewMode()) {
            webResourcesEvent.applyResourceRules(new WebResourceRule[]{WebResourceRule.addPackage((String)"jquery"), WebResourceRule.add((ViewElementBuilder)WebResource.css((String)"@static:/WebCmsModule/css/wcm-inline-editor.css")).withKey("WebCmsModule-inline-editor").toBucket("css"), WebResourceRule.add((ViewElementBuilder)WebResource.javascript((String)"@static:/WebCmsModule/js/wcm-preview-mode.js")).withKey("WebCmsModule-preview").toBucket("javascript-page-end")});
        }
    }

    public WebCmsEndpointHandlerInterceptor(WebCmsEndpointContext context) {
        this.context = context;
    }
}

