/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.WebCmsObjectNotFoundException;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.WebCmsImageRepository;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StreamUtils;

@Component
final class StringToWebCmsImageConverter
implements Converter<String, WebCmsImage> {
    private final ApplicationContext applicationContext;
    private final WebCmsImageConnector imageConnector;
    private final WebCmsImageRepository imageRepository;
    private final WebCmsMultiDomainService multiDomainService;

    public WebCmsImage convert(String source) {
        try {
            WebCmsImage image = this.retrieveOrCreateImage(source);
            if (image == null) {
                throw new WebCmsObjectNotFoundException(source, WebCmsImage.class);
            }
            return image;
        }
        catch (Exception re) {
            if (re instanceof WebCmsObjectNotFoundException) {
                throw (WebCmsObjectNotFoundException)re;
            }
            throw new WebCmsObjectNotFoundException(source, WebCmsImage.class, re);
        }
    }

    private WebCmsImage retrieveOrCreateImage(String source) throws IOException {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        if (WebCmsUtils.isObjectIdForCollection(source, "wcm:asset:image")) {
            return this.imageRepository.findOneByObjectId(source).orElse(null);
        }
        WebCmsDomain currentDomain = this.multiDomainService.getCurrentDomainForType(WebCmsImage.class);
        String objectId = this.generateImageObjectId(source, currentDomain);
        WebCmsImage image = this.imageRepository.findOneByObjectId(objectId).orElse(null);
        if (image == null) {
            Resource imageResource = this.applicationContext.getResource(source);
            if (!imageResource.exists()) {
                throw new IllegalArgumentException("Image resource does not exist: " + source);
            }
            image = WebCmsImage.builder().objectId(objectId).domain(currentDomain).name(imageResource.getFilename()).published(true).build();
            byte[] imageData = StreamUtils.copyToByteArray((InputStream)imageResource.getInputStream());
            this.imageConnector.saveImageData(image, imageData);
            this.imageRepository.save(image);
        }
        return image;
    }

    private String generateImageObjectId(String source, WebCmsDomain domain) {
        String suffix = "import-" + DigestUtils.md5DigestAsHex((byte[])source.getBytes(Charset.forName("UTF-8")));
        if (!WebCmsDomain.isNoDomain(domain)) {
            suffix = suffix + "-" + DigestUtils.md5DigestAsHex((byte[])domain.getObjectId().getBytes());
        }
        return WebCmsUtils.prefixObjectIdForCollection(suffix, "wcm:asset:image");
    }

    @Autowired
    void registerConverter(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(String.class, WebCmsImage.class, this);
    }

    public StringToWebCmsImageConverter(ApplicationContext applicationContext, WebCmsImageConnector imageConnector, WebCmsImageRepository imageRepository, WebCmsMultiDomainService multiDomainService) {
        this.applicationContext = applicationContext;
        this.imageConnector = imageConnector;
        this.imageRepository = imageRepository;
        this.multiDomainService = multiDomainService;
    }
}

