/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.web.WebCmsAssetType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.image.ImageOwner;
import java.util.Date;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;

@Entity
@DiscriminatorValue(value="image")
@Table(name="wcm_image")
@NotThreadSafe
public class WebCmsImage
extends WebCmsAsset<WebCmsImage>
implements ImageOwner {
    public static final String OBJECT_TYPE = "image";
    public static final String COLLECTION_ID = "wcm:asset:image";
    @NotBlank
    @Column(name="name")
    @Length(max=255)
    private @NotBlank @Length(max=255) String name;
    @Column(name="external_id")
    @Length(max=255)
    private @Length(max=255) String externalId;
    @Column(name="source")
    @Length(max=255)
    private @Length(max=255) String source;
    @Column(name="description")
    private String description;
    @Column(name="keywords")
    private String keywords;

    protected WebCmsImage(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, boolean published, Date publicationDate, int sortIndex, String name, String externalId, String source, String description, String keywords) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain, published, publicationDate, sortIndex);
        this.name = name;
        this.externalId = externalId;
        this.source = source;
        this.description = description;
        this.keywords = keywords;
    }

    @Override
    public final String getObjectType() {
        return OBJECT_TYPE;
    }

    @Override
    protected final String getObjectCollectionId() {
        return COLLECTION_ID;
    }

    @Override
    public String toString() {
        return "WebCmsImage{objectId='" + this.getObjectId() + "',externalId='" + this.name + '\'' + '}';
    }

    @Override
    public WebCmsAssetType getAssetType() {
        return null;
    }

    @Override
    @Deprecated
    public Optional<String> getImageServerKey() {
        return Optional.ofNullable(this.externalId);
    }

    public static WebCmsImageBuilder builder() {
        return new WebCmsImageBuilder();
    }

    public WebCmsImageBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        WebCmsDomain domain = this.getDomain();
        boolean published = this.isPublished();
        Date publicationDate = this.getPublicationDate();
        int sortIndex = this.getSortIndex();
        return new WebCmsImageBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).domain(domain).published(published).publicationDate(publicationDate).sortIndex(sortIndex).name(this.name).externalId(this.externalId).source(this.source).description(this.description).keywords(this.keywords);
    }

    public WebCmsImage() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public static class WebCmsImageBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private WebCmsDomain domain;
        private boolean published;
        private Date publicationDate;
        private String name;
        private String externalId;
        private String source;
        private String description;
        private String keywords;
        private int sortIndex = 1000;

        WebCmsImageBuilder() {
        }

        public WebCmsImageBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsImageBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsImageBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsImageBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsImageBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsImageBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsImageBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsImageBuilder domain(WebCmsDomain domain) {
            this.domain = domain;
            return this;
        }

        public WebCmsImageBuilder published(boolean published) {
            this.published = published;
            return this;
        }

        public WebCmsImageBuilder publicationDate(Date publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        public WebCmsImageBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsImageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WebCmsImageBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public WebCmsImageBuilder source(String source) {
            this.source = source;
            return this;
        }

        public WebCmsImageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WebCmsImageBuilder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public WebCmsImage build() {
            return new WebCmsImage(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.domain, this.published, this.publicationDate, this.sortIndex, this.name, this.externalId, this.source, this.description, this.keywords);
        }

        public String toString() {
            return "WebCmsImage.WebCmsImageBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", domain=" + this.domain + ", published=" + this.published + ", publicationDate=" + this.publicationDate + ", sortIndex=" + this.sortIndex + ", name=" + this.name + ", externalId=" + this.externalId + ", source=" + this.source + ", description=" + this.description + ", keywords=" + this.keywords + ")";
        }
    }
}

