/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
class WebCmsImageInterceptor
extends EntityInterceptorAdapter<WebCmsImage> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsImageInterceptor.class);
    private final WebCmsImageConnector imageConnector;

    public boolean handles(Class<?> entityClass) {
        return WebCmsImage.class.isAssignableFrom(entityClass);
    }

    public void afterDelete(final WebCmsImage image) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                LOG.trace("Deleting physical image data for {}", (Object)image);
                WebCmsImageInterceptor.this.imageConnector.deleteImageData(image);
            }
        });
    }

    public WebCmsImageInterceptor(WebCmsImageConnector imageConnector) {
        this.imageConnector = imageConnector;
    }
}

