/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image.config;

import com.cloudinary.Cloudinary;
import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.OrderInModule;
import com.foreach.across.core.events.AcrossContextBootstrappedEvent;
import com.foreach.across.core.events.AcrossModuleBootstrappedEvent;
import com.foreach.across.modules.webcms.domain.image.config.CloudinaryProperties;
import com.foreach.across.modules.webcms.domain.image.config.ImageServerClientProperties;
import com.foreach.across.modules.webcms.domain.image.connector.CloudinaryWebCmsImageConnector;
import com.foreach.across.modules.webcms.domain.image.connector.ImageServerWebCmsImageConnector;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import com.foreach.imageserver.client.ImageRequestHashBuilder;
import com.foreach.imageserver.client.ImageServerClient;
import com.foreach.imageserver.client.Md5ImageRequestHashBuilder;
import com.foreach.imageserver.client.RemoteImageServerClient;
import java.util.HashMap;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnMissingBean(name={"webCmsImageConnector"})
class WebCmsImageConnectorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsImageConnectorConfiguration.class);
    static final String BEAN_NAME = "webCmsImageConnector";
    private final BeanFactory beanFactory;

    @Bean
    @Exposed
    @Primary
    public WebCmsImageConnector imageConnectorProxy(BeanFactory beanFactory) {
        LOG.trace("No WebCmsImageConnector bean present during module bootstrap - creating lazy initialization proxy.  Proxy will attempt to wire a bean named 'webCmsImageConnector' upon first use.");
        LazyInitTargetSource targetSource = new LazyInitTargetSource();
        targetSource.setTargetClass(WebCmsImageConnector.class);
        targetSource.setTargetBeanName(BEAN_NAME);
        targetSource.setBeanFactory(beanFactory);
        return (WebCmsImageConnector)ProxyFactory.getProxy(WebCmsImageConnector.class, (TargetSource)targetSource);
    }

    @EventListener
    @Order
    void verifyExistenceOfActualImageConnectorImplementation(AcrossContextBootstrappedEvent contextBootstrappedEvent) {
        if (!this.beanFactory.containsBean(BEAN_NAME)) {
            LOG.warn("No implementation of WebCmsImageConnector was found - a bean named {} was expected.  WebCmsImage related functionality will fail.", (Object)BEAN_NAME);
        }
    }

    public WebCmsImageConnectorConfiguration(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Configuration
    @ConditionalOnClass(value={Cloudinary.class})
    @EnableConfigurationProperties(value={CloudinaryProperties.class})
    static class CloudinaryAutoConfiguration {
        private final ConfigurableListableBeanFactory beanFactory;

        @Exposed
        @Bean
        @ConditionalOnProperty(prefix="web-cms-module.images.cloudinary", value={"enabled"}, havingValue="true")
        public Cloudinary cloudinary(CloudinaryProperties properties) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("cloud_name", properties.getCloudName());
            settings.put("api_key", properties.getApiKey());
            settings.put("api_secret", properties.getApiSecret());
            settings.putAll(properties.getSettings());
            return new Cloudinary(settings);
        }

        @EventListener
        @OrderInModule(value=1)
        void autoConfigureCloudinaryConnector(AcrossModuleBootstrappedEvent moduleBootstrappedEvent) {
            this.autoConfigureCloudinaryConnector(false);
        }

        @EventListener
        @OrderInModule(value=1)
        void autoConfigureCloudinaryConnector(AcrossContextBootstrappedEvent contextBootstrappedEvent) {
            this.autoConfigureCloudinaryConnector(true);
        }

        private void autoConfigureCloudinaryConnector(boolean last) {
            block4: {
                if (!this.beanFactory.containsBean(WebCmsImageConnectorConfiguration.BEAN_NAME)) {
                    try {
                        Cloudinary cloudinary = (Cloudinary)this.beanFactory.getBean(Cloudinary.class);
                        this.beanFactory.destroyBean((Object)WebCmsImageConnectorConfiguration.BEAN_NAME);
                        this.beanFactory.registerSingleton(WebCmsImageConnectorConfiguration.BEAN_NAME, (Object)new CloudinaryWebCmsImageConnector(cloudinary));
                        LOG.trace("Auto-created an CloudinaryWebCmsImageConnector using an existing Cloudinary bean.");
                    }
                    catch (NoUniqueBeanDefinitionException nube) {
                        LOG.error("More than one Cloudinary bean found and none marked primary - unable to auto-create CloudinaryWebCmsImageConnector.");
                    }
                    catch (NoSuchBeanDefinitionException nsbe) {
                        if (!last) break block4;
                        LOG.trace("No Cloudinary bean found - skipping auto-creation of CloudinaryWebCmsImageConnector.");
                    }
                }
            }
        }

        public CloudinaryAutoConfiguration(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ImageServerClient.class})
    @EnableConfigurationProperties(value={ImageServerClientProperties.class})
    static class ImageServerClientAutoConfiguration {
        private final ConfigurableListableBeanFactory beanFactory;

        @Exposed
        @Bean
        @ConditionalOnProperty(prefix="web-cms-module.images.image-server", value={"enabled"}, havingValue="true")
        public ImageServerClient imageServerClient(ImageServerClientProperties properties) {
            RemoteImageServerClient imageServerClient = new RemoteImageServerClient(properties.getUrl(), properties.getAccessToken());
            if (!StringUtils.isEmpty((String)properties.getHashToken())) {
                imageServerClient.setImageRequestHashBuilder((ImageRequestHashBuilder)new Md5ImageRequestHashBuilder(properties.getHashToken()));
            }
            return imageServerClient;
        }

        @EventListener
        @OrderInModule(value=1)
        void autoConfigureImageServerConnector(AcrossModuleBootstrappedEvent moduleBootstrappedEvent) {
            this.autoConfigureImageServerConnector(false);
        }

        @EventListener
        @OrderInModule(value=1)
        void autoConfigureImageServerConnector(AcrossContextBootstrappedEvent contextBootstrappedEvent) {
            this.autoConfigureImageServerConnector(true);
        }

        private void autoConfigureImageServerConnector(boolean last) {
            block4: {
                if (!this.beanFactory.containsBean(WebCmsImageConnectorConfiguration.BEAN_NAME)) {
                    try {
                        ImageServerClient imageServerClient = (ImageServerClient)this.beanFactory.getBean(ImageServerClient.class);
                        this.beanFactory.registerSingleton(WebCmsImageConnectorConfiguration.BEAN_NAME, (Object)new ImageServerWebCmsImageConnector(imageServerClient));
                        LOG.trace("Auto-created an ImageServerWebCmsImageConnector using an existing ImageServerClient bean.");
                    }
                    catch (NoUniqueBeanDefinitionException nube) {
                        LOG.error("More than one ImageServerClient bean found and none marked primary - unable to auto-create ImageServerWebCmsImageConnector.");
                    }
                    catch (NoSuchBeanDefinitionException nsbe) {
                        if (!last) break block4;
                        LOG.trace("No ImageServerClient bean found - skipping auto-creation of ImageServerWebCmsImageConnector.");
                    }
                }
            }
        }

        public ImageServerClientAutoConfiguration(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }
}

