/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image.connector;

import com.cloudinary.Cloudinary;
import com.cloudinary.Transformation;
import com.cloudinary.utils.ObjectUtils;
import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudinaryWebCmsImageConnector
implements WebCmsImageConnector {
    private static final Logger LOG = LoggerFactory.getLogger(CloudinaryWebCmsImageConnector.class);
    private final Cloudinary cloudinary;
    private boolean performDeletes = true;

    @Override
    public boolean saveImageData(WebCmsImage image, byte[] data) {
        if (image.isNew()) {
            Map result = this.cloudinary.uploader().upload((Object)data, ObjectUtils.asMap((Object[])new Object[0]));
            image.setExternalId((String)result.get("public_id"));
            return true;
        }
        return false;
    }

    @Override
    public String buildImageUrl(WebCmsImage image, int boxWidth, int boxHeight) {
        Transformation t = new Transformation();
        if (boxWidth > 0) {
            t.width((Object)boxWidth);
        }
        if (boxHeight > 0) {
            t.height((Object)boxHeight);
        }
        return this.cloudinary.url().format("jpg").transformation(t.crop("limit")).generate(image.getExternalId());
    }

    @Override
    public boolean deleteImageData(WebCmsImage image) {
        if (this.performDeletes) {
            try {
                this.cloudinary.uploader().destroy(image.getExternalId(), ObjectUtils.asMap((Object[])new Object[]{"invalidate", true}));
                return true;
            }
            catch (Exception e) {
                LOG.error("Failed to delete image file on Cloudinary", (Throwable)e);
            }
        }
        return false;
    }

    public CloudinaryWebCmsImageConnector(Cloudinary cloudinary) {
        this.cloudinary = cloudinary;
    }

    public void setPerformDeletes(boolean performDeletes) {
        this.performDeletes = performDeletes;
    }
}

