/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image.connector;

import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import com.foreach.imageserver.client.ImageServerClient;
import com.foreach.imageserver.dto.DimensionsDto;
import com.foreach.imageserver.dto.ImageInfoDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import com.foreach.imageserver.dto.ImageVariantDto;
import java.util.UUID;

public class ImageServerWebCmsImageConnector
implements WebCmsImageConnector {
    private final ImageServerClient imageServerClient;
    private String context = "default";
    private boolean performDeletes = true;

    @Override
    public boolean saveImageData(WebCmsImage image, byte[] data) {
        if (image.isNew()) {
            String externalId = UUID.randomUUID().toString();
            ImageInfoDto imageInfo = this.imageServerClient.loadImage(externalId, data);
            image.setExternalId(imageInfo.getExternalId());
            return true;
        }
        return false;
    }

    @Override
    public String buildImageUrl(WebCmsImage image, int boxWidth, int boxHeight) {
        ImageVariantDto variant = new ImageVariantDto();
        variant.setBoundaries(new DimensionsDto(boxWidth, boxHeight));
        variant.setImageType(ImageTypeDto.PNG);
        return this.imageServerClient.imageUrl(image.getExternalId(), this.context, 0, 0, variant);
    }

    @Override
    public boolean deleteImageData(WebCmsImage image) {
        if (this.performDeletes) {
            return this.imageServerClient.deleteImage(image.getExternalId());
        }
        return false;
    }

    public ImageServerWebCmsImageConnector(ImageServerClient imageServerClient) {
        this.imageServerClient = imageServerClient;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setPerformDeletes(boolean performDeletes) {
        this.performDeletes = performDeletes;
    }
}

