/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.image.web;

import com.foreach.across.modules.adminweb.ui.PageContentStructure;
import com.foreach.across.modules.bootstrapui.components.builder.DefaultNavComponentBuilder;
import com.foreach.across.modules.bootstrapui.elements.ColumnViewElement;
import com.foreach.across.modules.bootstrapui.elements.FormViewElement;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.web.links.EntityViewLinkBuilder;
import com.foreach.across.modules.web.menu.Menu;
import com.foreach.across.modules.web.menu.MenuSelector;
import com.foreach.across.modules.web.menu.PathBasedMenuBuilder;
import com.foreach.across.modules.web.menu.RequestMenuSelector;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnAdminUI
public class WebCmsImageFormViewProcessor
extends EntityViewProcessorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsImageFormViewProcessor.class);
    private final WebCmsImageConnector imageConnector;

    static Menu buildImageMenu(EntityViewRequest entityViewRequest, EntityViewLinkBuilder linkBuilder) {
        Menu menu = new PathBasedMenuBuilder().item("/details", "Search images", linkBuilder.toUriString()).order(1).and().item("/associations", "Upload new image", linkBuilder.createView().toUriString()).order(2).and().build();
        menu.sort();
        menu.select((MenuSelector)new RequestMenuSelector((HttpServletRequest)entityViewRequest.getWebRequest().getNativeRequest(HttpServletRequest.class)));
        return menu;
    }

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        command.addExtension("image", (Object)new ImageHolder());
    }

    protected void validateCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, Errors errors, HttpMethod httpMethod) {
        ImageHolder imageHolder;
        WebCmsImage image;
        if (HttpMethod.POST.equals((Object)httpMethod) && (image = (WebCmsImage)command.getEntity(WebCmsImage.class)).isNew() && !(imageHolder = (ImageHolder)command.getExtension("image", ImageHolder.class)).hasImageData()) {
            errors.rejectValue("extensions[image].imageData", "NotNull");
        }
    }

    protected void registerWebResources(EntityViewRequest entityViewRequest, EntityView entityView, WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"wcm-image-components-admin"});
    }

    protected void preProcess(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
        BindingResult bindingResult = entityViewRequest.getBindingResult();
        if (entityViewRequest.getHttpMethod().equals((Object)HttpMethod.POST) && bindingResult != null && !bindingResult.hasErrors()) {
            ImageHolder imageHolder = (ImageHolder)command.getExtension("image", ImageHolder.class);
            WebCmsImage image = (WebCmsImage)command.getEntity(WebCmsImage.class);
            if (imageHolder.hasImageData()) {
                try {
                    this.imageConnector.saveImageData(image, imageHolder.getImageData().getBytes());
                    image.setPublished(true);
                }
                catch (Exception e) {
                    LOG.error("Unable to upload file", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!bindingResult.hasErrors() && Boolean.parseBoolean(entityViewRequest.getWebRequest().getParameter("imageSelector"))) {
            EntityViewLinkBuilder linkBuilder = entityViewRequest.getEntityViewContext().getLinkBuilder();
            WebCmsImage imageCreated = (WebCmsImage)command.getEntity(WebCmsImage.class);
            entityView.setRedirectUrl(UriComponentsBuilder.fromUriString((String)linkBuilder.listView().withQueryParam("extensions[eqFilter]", new Object[]{"id = " + imageCreated.getId()}).withPartial(entityViewRequest.getPartialFragment()).toUriString()).toUriString());
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        PageContentStructure page = entityViewRequest.getPageContentStructure();
        page.setRenderAsTabs(true);
        page.addCssClass(new String[]{"wcm-image"});
        if (!entityViewRequest.getEntityViewContext().holdsEntity()) {
            page.addCssClass(new String[]{"wcm-image-upload"});
        }
        EntityViewLinkBuilder linkBuilder = entityViewRequest.getEntityViewContext().getLinkBuilder();
        if (!entityViewRequest.getEntityViewContext().holdsEntity()) {
            page.getHeader().clearChildren();
            Menu menu = WebCmsImageFormViewProcessor.buildImageMenu(entityViewRequest, linkBuilder);
            page.withNav(nav -> nav.addFirstChild(((DefaultNavComponentBuilder)BootstrapViewElements.bootstrap.builders.nav().menu(menu)).pills().build()));
        }
        ContainerViewElementUtils.find((ContainerViewElement)container, (String)"entityForm", FormViewElement.class).ifPresent(form -> {
            form.setHtmlId("wcm-image-upload-form");
            form.setEncType("multipart/form-data");
        });
        container.find("entityForm-column-1", ColumnViewElement.class).ifPresent(column -> container.removeAllFromTree(new String[]{"formGroup-name", "formGroup-source", "formGroup-description", "formGroup-keywords", "formGroup-externalId", "formGroup-lastModified"}).forEach(arg_0 -> ((ColumnViewElement)column).addChild(arg_0)));
    }

    public WebCmsImageFormViewProcessor(WebCmsImageConnector imageConnector) {
        this.imageConnector = imageConnector;
    }

    static class ImageHolder {
        private MultipartFile imageData;

        boolean hasImageData() {
            return this.imageData != null && !this.imageData.isEmpty();
        }

        public MultipartFile getImageData() {
            return this.imageData;
        }

        public void setImageData(MultipartFile imageData) {
            this.imageData = imageData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageHolder)) {
                return false;
            }
            ImageHolder other = (ImageHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MultipartFile this$imageData = this.getImageData();
            MultipartFile other$imageData = other.getImageData();
            return !(this$imageData == null ? other$imageData != null : !this$imageData.equals(other$imageData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MultipartFile $imageData = this.getImageData();
            result = result * 59 + ($imageData == null ? 43 : $imageData.hashCode());
            return result;
        }

        public String toString() {
            return "WebCmsImageFormViewProcessor.ImageHolder(imageData=" + this.getImageData() + ")";
        }
    }
}

