/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuRepository;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuService;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class StringToWebCmsMenuConverter
implements Converter<String, WebCmsMenu> {
    private final WebCmsMenuRepository webCmsMenuRepository;
    private final WebCmsMenuService menuService;

    @Autowired
    void registerToConversionService(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(this);
    }

    public WebCmsMenu convert(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return this.webCmsMenuRepository.findById(Long.parseLong(value)).orElse(null);
        }
        if (WebCmsUtils.isObjectIdForCollection(value, "wcm:menu")) {
            return this.webCmsMenuRepository.findOneByObjectId(value).orElse(null);
        }
        return this.menuService.getMenuByName(value);
    }

    public StringToWebCmsMenuConverter(WebCmsMenuRepository webCmsMenuRepository, WebCmsMenuService menuService) {
        this.webCmsMenuRepository = webCmsMenuRepository;
        this.menuService = menuService;
    }
}

