/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.core.annotations.PostRefresh;
import com.foreach.across.modules.web.menu.Menu;
import com.foreach.across.modules.webcms.domain.WebCmsObjectSuperClass;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItemRepository;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.stereotype.Component;

@Component
public final class WebCmsMenuCache {
    public static final String ENDPOINT_ID = "endpointId";
    public static final String ASSET_OBJECT_ID = "assetObjectId";
    private static final Cache DEFAULT_CACHE = new NoOpCache("WebCmsMenuCache");
    private final CacheManager cacheManager;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsMenuItemRepository menuItemRepository;
    private final WebCmsMenuService menuService;
    private Cache cache = DEFAULT_CACHE;

    public Collection<Menu> getMenuItems(String menuName) {
        WebCmsDomain currentDomain = this.multiDomainService.getCurrentDomainForType(WebCmsMenu.class);
        long domainId = WebCmsDomain.isNoDomain(currentDomain) ? 0L : currentDomain.getId();
        String cacheKey = domainId + ":" + menuName;
        Collection<Object> items = (List)this.cache.get((Object)cacheKey, Collection.class);
        if (items == null) {
            WebCmsMenu menu = this.menuService.getMenuByName(menuName, currentDomain);
            items = menu != null ? (Collection)this.menuItemRepository.findAllByMenu(menu).stream().map(menuItem -> {
                Menu item = new Menu(menuItem.getPath(), menuItem.getTitle());
                item.setOrder(menuItem.getSortIndex());
                item.setGroup(menuItem.isGroup());
                item.setDisabled(!this.isMenuItemAvailable((WebCmsMenuItem)((Object)menuItem)));
                item.setUrl(menuItem.getUrl());
                WebCmsEndpoint endpoint = menuItem.getEndpoint();
                if (!item.hasUrl() && endpoint != null) {
                    endpoint.getPrimaryUrl().ifPresent(url -> item.setUrl(url.getPath()));
                }
                if (endpoint != null) {
                    item.setAttribute(ENDPOINT_ID, (Object)menuItem.getEndpoint().getId());
                    if (endpoint instanceof WebCmsAssetEndpoint) {
                        item.setAttribute(ASSET_OBJECT_ID, (Object)((WebCmsObjectSuperClass)((WebCmsAssetEndpoint)endpoint).getAsset()).getObjectId());
                    }
                }
                return item;
            }).collect(Collectors.toList()) : Collections.emptyList();
            this.cache.put((Object)cacheKey, items);
        }
        return items;
    }

    private boolean isMenuItemAvailable(WebCmsMenuItem menuItem) {
        if (menuItem.hasEndpoint()) {
            WebCmsEndpoint endpoint = menuItem.getEndpoint();
            return !(endpoint instanceof WebCmsAssetEndpoint) || ((WebCmsAsset)((WebCmsAssetEndpoint)endpoint).getAsset()).isPublished();
        }
        return true;
    }

    public void remove(String menuName) {
        this.cache.evict((Object)menuName);
    }

    public void clear() {
        this.cache.clear();
    }

    @PostRefresh
    public void reloadCache() {
        Cache candidate = this.cacheManager.getCache("WebCmsMenuCache");
        this.cache = candidate != null ? (candidate instanceof TransactionAwareCacheDecorator ? candidate : new TransactionAwareCacheDecorator(candidate)) : DEFAULT_CACHE;
    }

    public WebCmsMenuCache(CacheManager cacheManager, WebCmsMultiDomainService multiDomainService, WebCmsMenuItemRepository menuItemRepository, WebCmsMenuService menuService) {
        this.cacheManager = cacheManager;
        this.multiDomainService = multiDomainService;
        this.menuItemRepository = menuItemRepository;
        this.menuService = menuService;
    }
}

