/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuCache;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import org.springframework.stereotype.Component;

@Component
class WebCmsMenuCacheInterceptor
extends EntityInterceptorAdapter<Object> {
    private final WebCmsMenuCache menuCache;

    public boolean handles(Class<?> entityClass) {
        return WebCmsMenu.class.isAssignableFrom(entityClass) || WebCmsMenuItem.class.isAssignableFrom(entityClass) || WebCmsEndpoint.class.isAssignableFrom(entityClass) || WebCmsUrl.class.isAssignableFrom(entityClass) || WebCmsAsset.class.isAssignableFrom(entityClass);
    }

    public void afterDelete(Object entity) {
        this.flushRelatedMenuItems(entity);
    }

    public void afterCreate(Object entity) {
        this.flushRelatedMenuItems(entity);
    }

    public void afterUpdate(Object entity) {
        this.flushRelatedMenuItems(entity);
    }

    public void afterDeleteAll(Class<?> entityClass) {
        this.menuCache.clear();
    }

    private void flushRelatedMenuItems(Object entity) {
        this.menuCache.clear();
    }

    public WebCmsMenuCacheInterceptor(WebCmsMenuCache menuCache) {
        this.menuCache = menuCache;
    }
}

