/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuRepository;
import com.foreach.across.modules.webcms.domain.menu.validators.WebCmsMenuValidator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsMenuImporter
extends AbstractWebCmsDataImporter<WebCmsMenu, WebCmsMenu> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsMenuImporter.class);
    private final WebCmsMenuRepository webCmsMenuRepository;
    private final WebCmsMenuValidator menuValidator;

    @Override
    public boolean supports(WebCmsDataEntry data) {
        return "menus".equals(data.getParentKey());
    }

    @Override
    protected WebCmsMenu retrieveExistingInstance(WebCmsDataEntry data) {
        String dataKey = data.getMapData().containsKey("name") ? (String)data.getMapData().get("name") : data.getKey();
        String objectId = (String)data.getMapData().get("objectId");
        if (objectId != null) {
            return this.webCmsMenuRepository.findOneByObjectId(objectId).orElse(null);
        }
        WebCmsDomain domain = this.retrieveDomainForDataEntry(data, WebCmsMenu.class);
        return this.webCmsMenuRepository.findOneByNameAndDomain(dataKey, domain).orElse(null);
    }

    @Override
    protected WebCmsMenu createDto(WebCmsDataEntry data, WebCmsMenu existing, WebCmsDataAction action, Map<String, Object> dataValues) {
        if (existing == null) {
            return this.createNewMenuDto(data);
        }
        if (action == WebCmsDataAction.REPLACE) {
            WebCmsMenu dto = this.createNewMenuDto(data);
            dto.setId(existing.getId());
            return dto;
        }
        return (WebCmsMenu)existing.toDto();
    }

    private WebCmsMenu createNewMenuDto(WebCmsDataEntry data) {
        String dataKey = data.getMapData().containsKey("name") ? (String)data.getMapData().get("name") : data.getKey();
        return WebCmsMenu.builder().name(dataKey).build();
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsMenu dto) {
        HashMap<String, Object> filtered = new HashMap<String, Object>(values);
        filtered.remove("items");
        return super.applyDataValues(filtered, dto);
    }

    @Override
    protected void deleteInstance(WebCmsMenu instance, WebCmsDataEntry data) {
        this.webCmsMenuRepository.delete(instance);
    }

    @Override
    protected void saveDto(WebCmsMenu dto, WebCmsDataAction action, WebCmsDataEntry data) {
        this.webCmsMenuRepository.save(dto);
    }

    @Override
    protected void validate(WebCmsMenu itemToBeSaved, Errors errors) {
        this.menuValidator.validate(itemToBeSaved, errors);
    }

    public WebCmsMenuImporter(WebCmsMenuRepository webCmsMenuRepository, WebCmsMenuValidator menuValidator) {
        this.webCmsMenuRepository = webCmsMenuRepository;
        this.menuValidator = menuValidator;
    }
}

